local cockpit = folder.."../../../Cockpit/"
local f14input = folder.."../../../Input/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")
dofile(f14input.."utils.lua")


local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")
local res2 = external_profile(f14input.."F-14B/keyboard/default.lua")
join_override(res.keyCommands, res2.keyCommands)
join_override(res.keyCommands,{

--Modifications

{down = device_commands.HYD_ISOL_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 0, name = _('-Hydraulic Isolation Switch ON'), category = { _('-MODIFICATIONS')}},
{down = device_commands.HYD_ISOL_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('-Hydraulic Isolation Switch OFF'), category = { _('-MODIFICATIONS')}},
{down = device_commands.HYD_ISOL_Switch, up = device_commands.HYD_ISOL_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 0, value_down = 1, name = _('-Hydraulic Isolation Switch ON<>OFF'), category = { _('-MODIFICATIONS')}},

{down = device_commands.HYD_EMERG_FLT_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = -1, name = _('-Hydraulic Emergency Flight Control AUTO'), category = { _('-MODIFICATIONS')}},
{down = device_commands.HYD_EMERG_FLT_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 0, name = _('-Hydraulic Emergency Flight Control LOW'), category = { _('-MODIFICATIONS')}},
{down = device_commands.HYD_EMERG_FLT_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('-Hydraulic Emergency Flight Control HIGH'), category = { _('-MODIFICATIONS')}},
{down = device_commands.HYD_EMERG_FLT_SwitchCover, 		cockpit_device_id = devices.HYDRAULICS, value_down = 0, name = _('-Hydraulic Emergency Flight Control Switch Cover CLOSE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.HYD_EMERG_FLT_SwitchCover, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('-Hydraulic Emergency Flight Control Switch Cover OPEN'), category = { _('-MODIFICATIONS')}},

{down = device_commands.INLET_RAMPS_LeftSwitch, 		cockpit_device_id = devices.AICS, value_down = 0, name = _('-Stow Inlet Ramps Left Switch AUTO'), category = { _('-MODIFICATIONS')}},
{down = device_commands.INLET_RAMPS_LeftSwitch, 		cockpit_device_id = devices.AICS, value_down = 1, name = _('-Stow Inlet Ramps Left Switch STOW'), category = { _('-MODIFICATIONS')}},
{down = device_commands.INLET_RAMPS_RightSwitch, 		cockpit_device_id = devices.AICS, value_down = 0, name = _('-Stow Inlet Ramps Right Switch AUTO'), category = { _('-MODIFICATIONS')}},
{down = device_commands.INLET_RAMPS_RightSwitch, 		cockpit_device_id = devices.AICS, value_down = 1, name = _('-Stow Inlet Ramps Right Switch STOW'), category = { _('-MODIFICATIONS')}},

{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, 		cockpit_device_id = devices.GEARHOOK, value_down = -1, name = _('-Anti-Skid Spoiler BK Switch SPOILER+BRK'), category = { _('-MODIFICATIONS')}},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, 		cockpit_device_id = devices.GEARHOOK, value_down = 0, name = _('-Anti-Skid Spoiler BK Switch OFF'), category = { _('-MODIFICATIONS')}},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, 		cockpit_device_id = devices.GEARHOOK, value_down = 1, name = _('-Anti-Skid Spoiler BK Switch BOTH'), category = { _('-MODIFICATIONS')}},

{down = device_commands.BRAKE_ParkingBrake, 		cockpit_device_id = devices.GEARHOOK, value_down = 0, name = _('-Parking Brake Handle ON'), category = { _('-MODIFICATIONS')}},
{down = device_commands.BRAKE_ParkingBrake, 		cockpit_device_id = devices.GEARHOOK, value_down = 1, name = _('-Parking Brake Handle OFF'), category = { _('-MODIFICATIONS')}},
{down = device_commands.BRAKE_ParkingBrake, up = device_commands.BRAKE_ParkingBrake, cockpit_device_id = devices.GEARHOOK, value_down = 0, value_up = 1, name = _('-Parking Brake Handle ON <> OFF'), category = { _('-MODIFICATIONS')}},

{down = device_commands.ENGINE_Throttle_Mode, 		cockpit_device_id = devices.ENGINE, value_down = -1, name = _('-Throttle Mode MAN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Throttle_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Throttle Mode BOOST'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Throttle_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('-Throttle Mode AUTO'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Throttle_Temp, 		cockpit_device_id = devices.ENGINE, value_down = -1, name = _('-Throttle Temp COLD'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Throttle_Temp, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Throttle Temp NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Throttle_Temp, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('-Throttle Temp HOT'), category = { _('-MODIFICATIONS')}},

{down = device_commands.ENGINE_Probe_Anti_Ice, 		cockpit_device_id = devices.ENGINE, value_down = -1, name = _('-Engine/Probe Anti-Ice OFF'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Probe_Anti_Ice, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Engine/Probe Anti-Ice AUTO'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Probe_Anti_Ice, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('-Engine/Probe Anti-Ice ORIDE'), category = { _('-MODIFICATIONS')}},

{down = device_commands.ENGINE_Air_Start, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Engine Airstart NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Air_Start, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('-Engine Airstart ON'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Crank, 			cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Crank Engine MIDDLE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Left_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Left Engine Mode PRI'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Left_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('-Left Engine Mode SEC'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Right_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('-Right Engine Mode PRI'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ENGINE_Right_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('-Right Engine Mode SEC'), category = { _('-MODIFICATIONS')}},

{down = device_commands.FUELSYSTEM_Fuel_Feed_Cover, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 0, name = _('-Fuel Feed Cover CLOSE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed_Cover, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 1, name = _('-Fuel Feed Cover OPEN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed, 		cockpit_device_id = devices.FUELSYSTEM, value_down = -1, name = _('-Fuel Feed AFT'), category = { _('-MODIFICATIONS')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 0, name = _('-Fuel Feed NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 1, name = _('-Fuel Feed FWD'), category = { _('-MODIFICATIONS')}},

{down = device_commands.ELEC_MASTER_GEN_LeftSwitch, 		cockpit_device_id = devices.ELECTRICS, value_down = -1, name = _('-Left Generator Switch TEST'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_MASTER_GEN_LeftSwitch, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Left Generator Switch OFF/RESET'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_MASTER_GEN_LeftSwitch, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Left Generator Switch NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_MASTER_GEN_RightSwitch, 		cockpit_device_id = devices.ELECTRICS, value_down = -1, name = _('-Right Generator Switch TEST'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_MASTER_GEN_RightSwitch, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Right Generator Switch OFF/RESET'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_MASTER_GEN_RightSwitch, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Right Generator Switch NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_EMERG_GEN_SwitchCover, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Emergency Generator Switch Cover CLOSE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_EMERG_GEN_SwitchCover, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Emergency Generator Switch Cover OPEN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_EMERG_GEN_Switch, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Emergency Generator Switch NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.ELEC_EMERG_GEN_Switch, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Emergency Generator Switch OFF/RESET'), category = { _('-MODIFICATIONS')}},

{down = device_commands.PilotOxygenOn, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 0, name = _('-Pilot Oxygen OFF'), category = { _('-MODIFICATIONS')}},
{down = device_commands.PilotOxygenOn, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Pilot Oxygen ON'), category = { _('-MODIFICATIONS')}},
{down = device_commands.CabinPressureDump, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 0, name = _('-Cabin Pressure Dump NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.CabinPressureDump, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Cabin Pressure Dump DUMP'), category = { _('-MODIFICATIONS')}},
{down = device_commands.AirSourceRam, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Air Source Ram'), category = { _('-MODIFICATIONS')}},
{down = device_commands.AirSourceOff, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Air Source Off'), category = { _('-MODIFICATIONS')}},
{down = device_commands.AirSourceLEng, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Air Source Left Engine'), category = { _('-MODIFICATIONS')}},
{down = device_commands.AirSourceREng, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Air Source Right Engine'), category = { _('-MODIFICATIONS')}},
{down = device_commands.AirSourceBoth, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Air Source Both Engines'), category = { _('-MODIFICATIONS')}},
{down = device_commands.WindShield_Air, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = -1, name = _('-Wind Shield Air OFF'), category = { _('-MODIFICATIONS')}},
{down = device_commands.WindShield_Air, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 0, name = _('-Wind Shield Air AIR'), category = { _('-MODIFICATIONS')}},
{down = device_commands.WindShield_Air, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Wind Shield Air RAIN'), category = { _('-MODIFICATIONS')}},

{down = device_commands.TempAutoMan, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 0, name = _('-Temp Auto / Man AUTO'), category = { _('-MODIFICATIONS')}},
{down = device_commands.TempAutoMan, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Temp Auto / Man MAN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.RamAir, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 0, name = _('-Ram Air DECR'), category = { _('-MODIFICATIONS')}},
{down = device_commands.RamAir, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('-Ram Air INCR'), category = { _('-MODIFICATIONS')}},

{down = device_commands.SPOIL_Inboard_Override_Cover, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Inboard Spoiler Override Cover CLOSE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Inboard_Override_Cover, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Inboard Spoiler Override Cover OPEN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Outboard_Override_Cover, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Outboard Spoiler Override Cover CLOSE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Outboard_Override_Cover, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Outboard Spoiler Override Cover OPEN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Inboard_Override, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Inboard Spoiler Override NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Inboard_Override, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Inboard Spoiler Override ORIDE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Outboard_Override, 		cockpit_device_id = devices.ELECTRICS, value_down = 0, name = _('-Outboard Spoiler Override NORM'), category = { _('-MODIFICATIONS')}},
{down = device_commands.SPOIL_Outboard_Override, 		cockpit_device_id = devices.ELECTRICS, value_down = 1, name = _('-Outboard Spoiler Override ORIDE'), category = { _('-MODIFICATIONS')}},

{down = device_commands.WEAP_Gun_Ammo_adjust, 		cockpit_device_id = devices.WEAPONS, value_down = 1.0, name = _('-Gun Ammunition Counter Adjustment (+100)'), category = { _('-MODIFICATIONS')}},
{down = device_commands.WEAP_Gun_Ammo_adjust, 		cockpit_device_id = devices.WEAPONS, value_down = -1.0, name = _('-Gun Ammunition Counter Adjustment (-100)'), category = { _('-MODIFICATIONS')}},

{down = device_commands.WINGSWEEP_EmergencySweepCover, 		cockpit_device_id = devices.WINGSWEEP, value_down = 0, name = _('Emergency Wing Sweep Cover CLOSE'), category = { _('-MODIFICATIONS')}},
{down = device_commands.WINGSWEEP_EmergencySweepCover, 		cockpit_device_id = devices.WINGSWEEP, value_down = 1, name = _('Emergency Wing Sweep Cover OPEN'), category = { _('-MODIFICATIONS')}},
{down = device_commands.WINGSWEEP_EmergencySweepCover,     up = device_commands.WINGSWEEP_EmergencySweepCover, value_down = 1, value_up = 0, cockpit_device_id = devices.WINGSWEEP, name = _('Emergency Wing Sweep Cover OPEN else CLOSED'), category = _('-MODIFICATIONS')},
{down = device_commands.WINGSWEEP_EmergencyLeverExtended,up=device_commands.WINGSWEEP_EmergencyLeverExtended, cockpit_device_id=devices.WINGSWEEP, value_down=1.0, value_up=0.0, name=_('Emergency Wing Sweep Handle PopOut else In'),	 category=_('-MODIFICATIONS')},


-- auto
{combos = {{key = 'Home', reformers = {'LWin'}}}, down = device_commands.AUTO_StartPilot, cockpit_device_id=devices.AUTO, value_down = 1, name = _('Auto Start'),		category = _('Cheat')},


--************** Engine and fuel *********************************************************************
{combos = {{key = 'T', reformers = {'LCtrl'}}},	down = device_commands.ENGINE_Throttle_Mode_Toggle, cockpit_device_id=devices.ENGINE, value_down = 1, name = _('Toggle Auto Throttle'), category = _('Engine Control Panel')},
{down = device_commands.ENGINE_Throttle_Mode, 		cockpit_device_id = devices.ENGINE, value_down = -1, name = _('Throttle Mode MAN'), category = { _('Throttle')}},
{down = device_commands.ENGINE_Throttle_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('Throttle Mode BOOST'), category = { _('Throttle')}},
{down = device_commands.ENGINE_Throttle_Mode, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Throttle Mode AUTO'), category = { _('Throttle')}},
{down = device_commands.ENGINE_Throttle_Mode,     up = device_commands.ENGINE_Throttle_Mode, value_down = -1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Throttle Mode MAN else BOOST'), category = _('Throttle')},
{down = device_commands.ENGINE_Throttle_Mode,     up = device_commands.ENGINE_Throttle_Mode, value_down = 1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Throttle Mode AUTO else BOOST'), category = _('Throttle')},
{down = device_commands.ENGINE_AfterBurner_Gate,     up = device_commands.ENGINE_AfterBurner_Gate, value_down = 1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Afterburner Gate'), category = _('Throttle')},
{down = device_commands.ENGINE_Mid_Compression_Bypass_CB,     up = device_commands.ENGINE_Mid_Compression_Bypass_CB, value_down = 1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Mid Compression Bypass CB Pull - TF30 only'), category = _('Engine Control Panel')},
{down = device_commands.FIRE_Bottle_Fire_L,     up = device_commands.FIRE_Bottle_Fire_L , value_down = 0, value_up = 1, cockpit_device_id = devices.FIRE, name = _('Left Engine Fire Agent Discharge'), category = _('Firewall')},
{down = device_commands.FIRE_Bottle_Fire_R,     up = device_commands.FIRE_Bottle_Fire_R , value_down = 0, value_up = 1, cockpit_device_id = devices.FIRE, name = _('Right Engine Fire Agent Discharge'), category = _('Firewall')},

{down = device_commands.ENGINE_Crank, cockpit_device_id=devices.ENGINE, value_down = 1, name = _('Crank Left Engine'), category = _('Engine Control Panel')},
{down = device_commands.ENGINE_Crank, cockpit_device_id=devices.ENGINE, value_down = -1, name = _('Crank Right Engine'), category = _('Engine Control Panel')},

{down = device_commands.FUELSYSTEM_WingExt_Trans,     up = device_commands.FUELSYSTEM_WingExt_Trans, value_down = 1, value_up = 0, cockpit_device_id=devices.FUELSYSTEM, name = _('Wing/External Transfer Oride, else Auto'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_WingExt_Trans,     up = device_commands.FUELSYSTEM_WingExt_Trans, value_down = -1, value_up = 0, cockpit_device_id=devices.FUELSYSTEM, name = _('Wing/External Transfer Off, else Auto'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_WingExt_Trans, cockpit_device_id=devices.FUELSYSTEM, value_down = 1, name = _('Wing/External Transfer Oride'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_WingExt_Trans, cockpit_device_id=devices.FUELSYSTEM, value_down = 0, name = _('Wing/External Transfer Auto'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_WingExt_Trans, cockpit_device_id=devices.FUELSYSTEM, value_down = -1, name = _('Wing/External Transfer Off'), category = _('Fuelsystem Control Panel')},

{down = device_commands.FUELSYSTEM_Dump,     up = device_commands.FUELSYSTEM_Dump, value_down = 1, value_up = -1, cockpit_device_id=devices.FUELSYSTEM, name = _('Fueldump Dump, else Off'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Dump,     up = device_commands.FUELSYSTEM_Dump, value_down = -1, value_up = 1, cockpit_device_id=devices.FUELSYSTEM, name = _('Fueldump Off, else Dump'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Dump, cockpit_device_id=devices.FUELSYSTEM, value_down = -1, name = _('Fueldump Off'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Dump, cockpit_device_id=devices.FUELSYSTEM, value_down = 1, name = _('Fueldump Dump'), category = _('Fuelsystem Control Panel')},

{down = device_commands.FUELSYSTEM_Refuel_Probe,     up = device_commands.FUELSYSTEM_Refuel_Probe, value_down = 1, value_up = -1, cockpit_device_id=devices.FUELSYSTEM, name = _('Refuel Probe extend & Refuel All, else Retract Probe'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Refuel_Probe,     up = device_commands.FUELSYSTEM_Refuel_Probe, value_down = 0, value_up = -1, cockpit_device_id=devices.FUELSYSTEM, name = _('Refuel Probe extend & Refuel Fuselage, else Retract Probe'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Refuel_Probe,     up = device_commands.FUELSYSTEM_Refuel_Probe, value_down = 1, value_up = 0, cockpit_device_id=devices.FUELSYSTEM, name = _('Refuel Probe extend & Refuel All, else Refuel Fuselage'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Refuel_Probe,     up = device_commands.FUELSYSTEM_Refuel_Probe, value_down = -1, value_up = 0, cockpit_device_id=devices.FUELSYSTEM, name = _('Refuel Probe retract, else extend & Refuel Fuselage'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Refuel_Probe, cockpit_device_id=devices.FUELSYSTEM, value_down = 1, name = _('Refuel Probe extend, Refuel All'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Refuel_Probe, cockpit_device_id=devices.FUELSYSTEM, value_down = 0, name = _('Refuel Probe extend, Refuel Fuselage'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Refuel_Probe, cockpit_device_id=devices.FUELSYSTEM, value_down = -1, name = _('Refuel Probe Retract'), category = _('Fuelsystem Control Panel')},

{down = device_commands.FUELSYSTEM_Fuel_Qty_Sel,     up = device_commands.FUELSYSTEM_Fuel_Qty_Sel, value_down = 1, value_up = 0, cockpit_device_id=devices.FUELSYSTEM, name = _('QTY Select Wing, else Feed'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Fuel_Qty_Sel,     up = device_commands.FUELSYSTEM_Fuel_Qty_Sel, value_down = -1, value_up = 0, cockpit_device_id=devices.FUELSYSTEM, name = _('QTY select External, else Feed'), category = _('Fuelsystem Control Panel')},

{down = device_commands.MASTER_Reset,     up = device_commands.MASTER_Reset, value_down = 1, value_up = 0, cockpit_device_id=devices.CADC, name = _('MASTER RESET'), category = _('Flight Control')},
{combos = {{key = 'Q',reformers={'LCtrl'}}}, down = device_commands.GEAR_Strut, value_down = 1, cockpit_device_id=devices.GEARHOOK, name = _('Nose strut extend'), category = _('Flight Control')},
{combos = {{key = 'A',reformers={'LCtrl'}}}, down = device_commands.GEAR_Strut, value_down = -1, cockpit_device_id=devices.GEARHOOK, name = _('Nose strut kneel'), category = _('Flight Control')},
{down = device_commands.GEAR_Strut, value_down = 0, cockpit_device_id=devices.GEARHOOK, name = _('Nose strut off'), category = _('Flight Control')},

{down = device_commands.PilotOxygenOn, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 0, name = _('Pilot Oxygen OFF'), category = { _('Left sidewall')}},
{down = device_commands.PilotOxygenOn, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('Pilot Oxygen ON'), category = { _('Left sidewall')}},
{down = device_commands.PilotOxygenOn,     up = device_commands.PilotOxygenOn, value_down = 1, value_up = 0, cockpit_device_id = devices.COCKPITMECHANICS, name = _('Pilot Oxygen ON, else OFF'), category = _('Left sidewall')},
{down = device_commands.PilotOxygen_toggle, 		cockpit_device_id = devices.COCKPITMECHANICS, value_down = 1, name = _('Pilot Oxygen Toggle'), category = { _('Left sidewall')}},

{down = device_commands.WINGSWEEP_EmergencySweepCover, 		cockpit_device_id = devices.WINGSWEEP, value_down = 0, name = _('Emergency Wing Sweep Handle Cover CLOSE'), category = { _('Throttle')}},
{down = device_commands.WINGSWEEP_EmergencySweepCover, 		cockpit_device_id = devices.WINGSWEEP, value_down = 1, name = _('Emergency Wing Sweep Handle Cover OPEN'), category = { _('Throttle')}},
{down = device_commands.WINGSWEEP_EmergencySweepCover,     up = device_commands.WINGSWEEP_EmergencySweepCover, value_down = 1, value_up = 0, cockpit_device_id = devices.WINGSWEEP, name = _('Emergency Wing Sweep Handle Cover OPEN else CLOSED'), category = _('Throttle')},
{down = device_commands.WINGSWEEP_EmergencySweepCover_toggle, 		cockpit_device_id = devices.WINGSWEEP, value_down = 1, name = _('Emergency Wing Sweep Handle Cover Toggle'), category = { _('Throttle')}},
{pressed = device_commands.Emergency_Wingsweep_step, cockpit_device_id=devices.WINGSWEEP, value_pressed = 0.01, value_up = 0, name = _('Emergency Wing Sweep Handle move Fwd'), category = _('Throttle')},
{pressed = device_commands.Emergency_Wingsweep_step, cockpit_device_id=devices.WINGSWEEP, value_pressed = -0.01, value_up = 0, name = _('Emergency Wing Sweep Handle move Aft'), category = _('Throttle')},
{down = device_commands.WINGSWEEP_EmergencyLeverExtended, cockpit_device_id=devices.WINGSWEEP, value_down = 1.0, name = _('Emergency Wing Sweep Handle Pull'), category = _('Throttle')},
{down = device_commands.WINGSWEEP_EmergencyLeverExtended, cockpit_device_id=devices.WINGSWEEP, value_down = 0.0, name = _('Emergency Wing Sweep Handle Push'), category = _('Throttle')},
{down = device_commands.WINGSWEEP_EmergencyLeverExtended, up = device_commands.WINGSWEEP_EmergencyLeverExtended, cockpit_device_id=devices.WINGSWEEP, value_down = 1.0, value_up = 0.0, name = _('Emergency Wing Sweep Handle Pulled else Pushed'), category = _('Throttle')},
{down = device_commands.WINGSWEEP_EmergencyLeverExtended, up = device_commands.WINGSWEEP_EmergencyLeverExtended, cockpit_device_id=devices.WINGSWEEP, value_down = 0.0, value_up = 1.0, name = _('Emergency Wing Sweep Handle Pushed else Pulled'), category = _('Throttle')},
{down = device_commands.WINGSWEEP_EmergencyLeverExtended_toggle, cockpit_device_id=devices.WINGSWEEP, value_down = 1.0, name = _('Emergency Wing Sweep Handle Pushed/ Pulled toggle'), category = _('Throttle')},

{down = device_commands.ENGINE_Probe_Anti_Ice, 		cockpit_device_id = devices.ENGINE, value_down = -1, name = _('Eng/Probe Anti Ice OFF'), category = { _('External Environment')}},
{down = device_commands.ENGINE_Probe_Anti_Ice, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('Eng/Probe Anti Ice AUTO'), category = { _('External Environment')}},
{down = device_commands.ENGINE_Probe_Anti_Ice, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Eng/Probe Anti Ice ORIDE'), category = { _('External Environment')}},
{down = device_commands.ENGINE_Probe_Anti_Ice,     up = device_commands.ENGINE_Probe_Anti_Ice, value_down = -1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Eng/Probe Anti Ice OFF, else AUTO'), category = _('External Environment')},
{down = device_commands.ENGINE_Probe_Anti_Ice,     up = device_commands.ENGINE_Probe_Anti_Ice, value_down = 1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Eng/Probe Anti Ice ORIDE, else AUTO'), category = _('External Environment')},
{down = device_commands.ENGINE_Probe_Anti_Ice_toggle, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Eng/Probe Anti Ice Toggle'), category = { _('External Environment')}},

{down = device_commands.ENGINE_Asym_LimiterCover, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('Asymmetric Thrust Limiter Cover CLOSE'), category = { _('Engine Control Panel')}},
{down = device_commands.ENGINE_Asym_LimiterCover, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Asymmetric Thrust Limiter Cover OPEN'), category = { _('Engine Control Panel')}},
{down = device_commands.ENGINE_Asym_LimiterCover,     up = device_commands.ENGINE_Asym_LimiterCover, value_down = 1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Asymmetric Thrust Limiter Cover OPEN else CLOSED'), category = _('Engine Control Panel')},
{down = device_commands.ENGINE_Asym_LimiterCover_toggle, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Asymmetric Thrust Limiter Cover Toggle'), category = { _('Engine Control Panel')}},
{down = device_commands.ENGINE_Asym_Limiter, 		cockpit_device_id = devices.ENGINE, value_down = 0, name = _('Asymmetric Thrust Limiter ON'), category = { _('Engine Control Panel')}},
{down = device_commands.ENGINE_Asym_Limiter, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Asymmetric Thrust Limiter OFF'), category = { _('Engine Control Panel')}},
{down = device_commands.ENGINE_Asym_Limiter,     up = device_commands.ENGINE_Asym_Limiter, value_down = 1, value_up = 0, cockpit_device_id = devices.ENGINE, name = _('Asymmetric Thrust Limiter OFF else ON'), category = _('Engine Control Panel')},
{down = device_commands.ENGINE_Asym_Limiter_toggle, 		cockpit_device_id = devices.ENGINE, value_down = 1, name = _('Asymmetric Thrust Limiter Toggle'), category = { _('Engine Control Panel')}},

{down = device_commands.HYD_TRANSFER_PUMP_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 0, name = _('Hydraulic Transfer Pump Switch NORMAL'), category = { _('Right Sidewall')}},
{down = device_commands.HYD_TRANSFER_PUMP_Switch, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('Hydraulic Transfer Pump Switch SHUTOFF'), category = { _('Right Sidewall')}},
{down = device_commands.HYD_TRANSFER_PUMP_Switch,     up = device_commands.HYD_TRANSFER_PUMP_Switch, value_down = 1, value_up = 0, cockpit_device_id = devices.HYDRAULICS, name = _('Hydraulic Transfer Pump Switch SHUTOFF else NORMAL'), category = _('Right Sidewall')},
{down = device_commands.HYD_TRANSFER_PUMP_Switch_toggle, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('Hydraulic Transfer Pump Switch Toggle'), category = { _('Right Sidewall')}},
{down = device_commands.HYD_HandPump,     up = device_commands.HYD_HandPump, value_down = 1, value_up = 0, cockpit_device_id = devices.HYDRAULICS, name = _('Hydraulic Hand Pump'), category = _('Cockpit Mechanics')},

{down = device_commands.HYD_TRANSFER_PUMP_SwitchCover, 		cockpit_device_id = devices.HYDRAULICS, value_down = 0, name = _('Hydraulic Transfer Pump Switch Cover CLOSE'), category = { _('Right Sidewall')}},
{down = device_commands.HYD_TRANSFER_PUMP_SwitchCover, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('Hydraulic Transfer Pump Switch Cover OPEN'), category = { _('Right Sidewall')}},
{down = device_commands.HYD_TRANSFER_PUMP_SwitchCover,     up = device_commands.HYD_TRANSFER_PUMP_SwitchCover, value_down = 1, value_up = 0, cockpit_device_id = devices.HYDRAULICS, name = _('Hydraulic Transfer Pump Switch Cover OPEN else CLOSE'), category = _('Right Sidewall')},
{down = device_commands.HYD_TRANSFER_PUMP_SwitchCover_toggle, 		cockpit_device_id = devices.HYDRAULICS, value_down = 1, name = _('Hydraulic Transfer Pump Switch Cover Toggle'), category = { _('Right Sidewall')}},

{down = device_commands.BIT_Selector_step, 		cockpit_device_id = devices.BITPANEL, value_down = 1, name = _('Master Test Selector CW'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector_step, 		cockpit_device_id = devices.BITPANEL, value_down = -1, name = _('Master Test Selector CCW'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 0.0, name = _('Master Test Selector: OFF'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 1.0/11.0, name = _('Master Test Selector: LTS'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 2.0/11.0, name = _('Master Test Selector: FIRE DET/EXT'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 3.0/11.0, name = _('Master Test Selector: INST'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 4.0/11.0, name = _('Master Test Selector: OBC'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 5.0/11.0, name = _('Master Test Selector: EMERG GEN'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 6.0/11.0, name = _('Master Test Selector: WG SWP'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 7.0/11.0, name = _('Master Test Selector: FLTGR DW'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 8.0/11.0, name = _('Master Test Selector: FLTGR UP'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 9.0/11.0, name = _('Master Test Selector: D/L RAD'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_Selector, 		cockpit_device_id = devices.BITPANEL, value_down = 10.0/11.0, name = _('Master Test Selector: STICK SW'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_SelectorPush, up = device_commands.BIT_SelectorPush, 		cockpit_device_id = devices.BITPANEL, value_down = 1.0, value_up = 0.0, name = _('Master Test Selector PULLED else PUSHED'), category = { _('Right Sidewall')}},
{down = device_commands.BIT_SelectorPush_toggle,	cockpit_device_id = devices.BITPANEL, value_down = 1.0, name = _('Master Test Selector push/pull toggle'), category = { _('Right Sidewall')}},

{down = device_commands.FUELSYSTEM_Fuel_Feed_Cover, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 0, name = _('Fuel Feed Cover CLOSE'), category = { _('Fuelsystem Control Panel')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed_Cover, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 1, name = _('Fuel Feed Cover OPEN'), category = { _('Fuelsystem Control Panel')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed_Cover,     up = device_commands.FUELSYSTEM_Fuel_Feed_Cover, value_down = 1, value_up = 0, cockpit_device_id = devices.FUELSYSTEM, name = _('Fuel Feed Cover OPEN else CLOSE'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Fuel_Feed_Cover_toggle, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 1.0, name = _('Fuel Feed Cover Toggle'), category = { _('Fuelsystem Control Panel')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed, 		cockpit_device_id = devices.FUELSYSTEM, value_down = -1, name = _('Fuel Feed AFT'), category = { _('Fuelsystem Control Panel')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 0, name = _('Fuel Feed NORM'), category = { _('Fuelsystem Control Panel')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 1, name = _('Fuel Feed FWD'), category = { _('Fuelsystem Control Panel')}},
{down = device_commands.FUELSYSTEM_Fuel_Feed,     up = device_commands.FUELSYSTEM_Fuel_Feed, value_down = 1, value_up = 0, cockpit_device_id = devices.FUELSYSTEM, name = _('Fuel Feed FWD else NORM'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Fuel_Feed,     up = device_commands.FUELSYSTEM_Fuel_Feed, value_down = -1, value_up = 0, cockpit_device_id = devices.FUELSYSTEM, name = _('Fuel Feed AFT else NORM'), category = _('Fuelsystem Control Panel')},
{down = device_commands.FUELSYSTEM_Fuel_Feed_toggle, 		cockpit_device_id = devices.FUELSYSTEM, value_down = 1, name = _('Fuel Feed Toggle'), category = { _('Fuelsystem Control Panel')}},
{pressed = device_commands.FUELSYSTEM_Bingo_Knob, cockpit_device_id=devices.FUELSYSTEM, value_pressed = 0.02, value_up = 0, name = _('BINGO Fuel Level Knob Inc'), category = _('Fuelsystem Control Panel')},
{pressed = device_commands.FUELSYSTEM_Bingo_Knob, cockpit_device_id=devices.FUELSYSTEM, value_pressed = -0.02, value_up = 0, name = _('BINGO Fuel Level Knob Dec'), category = _('Fuelsystem Control Panel')},

--******************* Flight Control *****************************************************************

-- Flight Control
{combos = {{key = 'Up'}},									pressed = iCommandPlaneUpStart, name = _('Aircraft Pitch Down'), category = _('Flight Control')},
{combos = {{key = 'Down'}},									pressed = iCommandPlaneDownStart, name = _('Aircraft Pitch Up'), category = _('Flight Control')},
{combos = {{key = 'Left'}}, down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = _('Aircraft Bank Left'), category = _('Flight Control')},
{combos = {{key = 'Right'}}, down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = _('Aircraft Bank Right'), category = _('Flight Control')},
{combos = {{key = 'Z'}}, down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = _('Aircraft Rudder Left'), category = _('Flight Control')},
{combos = {{key = 'X'}}, down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = _('Aircraft Rudder Right'), category = _('Flight Control')},

{combos = {{key = 'U'}}, down = iCommandPlaneShipTakeOff, name = _('Catapult Hook up'), category = _('Flight Control')},
{combos = {{key = 'U',reformers={'LShift'}}}, down=device_commands.CATAPULT_Salute, 	cockpit_device_id=devices.GEARHOOK, value_down=1.0, name = _('Catapult Salute'), category = _('Flight Control')},

{combos = {{key = 'Num+'}},									pressed = iCommandThrottleIncrease, up = iCommandThrottle1Stop, name = _('Throttle Up'), category = _('Flight Control')},
{combos = {{key = 'Num-'}},									pressed = iCommandThrottleDecrease, up = iCommandThrottle1Stop, name = _('Throttle Down'), category = _('Flight Control')},


{combos = {{key = ';', reformers = {'RCtrl'}}}, up=iCommandPlaneTrimPitch, pressed=iCommandPlaneTrimPitch, value_up=0.0, value_pressed=1.0,	name=_('Trim Pitch Up'),			 category = _('Flight Control')},
{combos = {{key = '.', reformers = {'RCtrl'}}}, up=iCommandPlaneTrimPitch, pressed=iCommandPlaneTrimPitch, value_up=0.0, value_pressed=-1.0,	name=_('Trim Pitch Down'),			 category = _('Flight Control')},
{combos = {{key = ',', reformers = {'RCtrl'}}}, up=iCommandPlaneTrimRoll, pressed=iCommandPlaneTrimRoll, value_up=0.0, value_pressed=-1.0,	name=_('Trim Roll Left Wing Down'), category = _('Flight Control')},
{combos = {{key = '/', reformers = {'RCtrl'}}}, up=iCommandPlaneTrimRoll, pressed=iCommandPlaneTrimRoll, value_up=0.0, value_pressed=1.0,		name=_('Trim Roll Right Wing Down'),category = _('Flight Control')},
{combos = {{key = 'Z', reformers = {'RCtrl'}}}, up=iCommandPlaneTrimRudder, pressed=iCommandPlaneTrimRudder, value_up=0.0, value_pressed=-1.0,name=_('Trim Rudder Left'),		 category = _('Flight Control')},
{combos = {{key = 'X', reformers = {'RCtrl'}}}, up=iCommandPlaneTrimRudder, pressed=iCommandPlaneTrimRudder, value_up=0.0, value_pressed=1.0,	name=_('Trim Rudder Right'),		 category = _('Flight Control')},

-- SAS
{down = device_commands.AFCS_Stability_Pitch,     up = device_commands.AFCS_Stability_Pitch, value_down = 1, value_up = -1, cockpit_device_id=devices.AFCS, name = _('AFCS Pitch Stabilisation On, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Pitch,     up = device_commands.AFCS_Stability_Pitch, value_down = -1, value_up = 1, cockpit_device_id=devices.AFCS, name = _('AFCS Pitch Stabilisation Off, else On'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Pitch, cockpit_device_id=devices.AFCS, value_down = 1, name = _('AFCS Pitch Stabilisation On'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Pitch, cockpit_device_id=devices.AFCS, value_down = -1, name = _('AFCS Pitch Stabilisation Off'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Pitch_Toggle, cockpit_device_id=devices.AFCS, value_down = 1, name = _('AFCS Pitch Stabilisation Toggle'), category = _('AFCS Control Panel')},

{down = device_commands.AFCS_Stability_Roll,     up = device_commands.AFCS_Stability_Roll, value_down = 1, value_up = -1, cockpit_device_id=devices.AFCS, name = _('AFCS Roll Stabilisation On, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Roll,     up = device_commands.AFCS_Stability_Roll, value_down = -1, value_up = 1, cockpit_device_id=devices.AFCS, name = _('AFCS Roll Stabilisation Off, else On'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Roll, cockpit_device_id=devices.AFCS, value_down = 1, name = _('AFCS Roll Stabilisation On'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Roll, cockpit_device_id=devices.AFCS, value_down = -1, name = _('AFCS Roll Stabilisation Off'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Roll_Toggle, cockpit_device_id=devices.AFCS, value_down = 1, name = _('AFCS Roll Stabilisation Toggle'), category = _('AFCS Control Panel')},

{down = device_commands.AFCS_Stability_Yaw,     up = device_commands.AFCS_Stability_Yaw, value_down = 1, value_up = -1, cockpit_device_id=devices.AFCS, name = _('AFCS Yaw Stabilisation On, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Yaw,     up = device_commands.AFCS_Stability_Yaw, value_down = -1, value_up = 1, cockpit_device_id=devices.AFCS, name = _('AFCS Yaw Stabilisation Off, else On'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Yaw, cockpit_device_id=devices.AFCS, value_down = 1, name = _('AFCS Yaw Stabilisation On'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Yaw, cockpit_device_id=devices.AFCS, value_down = -1, name = _('AFCS Yaw Stabilisation Off'), category = _('AFCS Control Panel')},
{down = device_commands.AFCS_Stability_Yaw_Toggle, cockpit_device_id=devices.AFCS, value_down = 1, name = _('AFCS Yaw Stabilisation Toggle'), category = _('AFCS Control Panel')},

-- Autopilot
{down = device_commands.AP_Vector,     up = device_commands.AP_Vector, value_down = 1, value_up = 0, cockpit_device_id=devices.AFCS, name = _('Autopilot Vector VEC/PCD, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Vector,     up = device_commands.AP_Vector, value_down = -1, value_up = 0, cockpit_device_id=devices.AFCS, name = _('Autopilot Vector ACL, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Vector, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Autopilot Vector VEC/PCD'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Vector, cockpit_device_id=devices.AFCS, value_down = 0, name = _('Autopilot Vector Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Vector, cockpit_device_id=devices.AFCS, value_down = -1, name = _('Autopilot Vector ACL'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Vector_toggle_offvec, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Autopilot Vector Toggle VEC/PCD'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Vector_toggle_offacl, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Autopilot Vector Toggle ACL'), category = _('AFCS Control Panel')},

{down = device_commands.AP_Altitude,     up = device_commands.AP_Altitude, value_down = 1, value_up = -1, cockpit_device_id=devices.AFCS, name = _('Altitude Hold On, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Altitude,     up = device_commands.AP_Altitude, value_down = -1, value_up = 1, cockpit_device_id=devices.AFCS, name = _('Altitude Hold Off, else On'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Altitude, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Altitude Hold On'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Altitude, cockpit_device_id=devices.AFCS, value_down = -1, name = _('Altitude Hold Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Altitude_toggle, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Altitude Hold Toggle'), category = _('AFCS Control Panel')},

{down = device_commands.AP_Heading,     up = device_commands.AP_Heading, value_down = 1, value_up = 0, cockpit_device_id=devices.AFCS, name = _('Heading Hold On, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Heading,     up = device_commands.AP_Heading, value_down = -1, value_up = 0, cockpit_device_id=devices.AFCS, name = _('Heading Hold GT, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Heading, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Heading Hold On'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Heading, cockpit_device_id=devices.AFCS, value_down = 0, name = _('Heading Hold Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Heading, cockpit_device_id=devices.AFCS, value_down = -1, name = _('Heading Hold GT'), category = _('AFCS Control Panel')},
--{down = device_commands.AP_Heading_toggle_offgt, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Autopilot Heading Toggle GT'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Heading_toggle_offon, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Autopilot Heading Toggle On'), category = _('AFCS Control Panel')},

{down = device_commands.AP_Engage,     up = device_commands.AP_Engage, value_down = 1, value_up = -1, cockpit_device_id=devices.AFCS, name = _('Autopilot On, else Off'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Engage,     up = device_commands.AP_Engage, value_down = -1, value_up = 1, cockpit_device_id=devices.AFCS, name = _('Autopilot Off, else On'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Engage, cockpit_device_id=devices.AFCS, value_down = 1, name = _('Autopilot On'), category = _('AFCS Control Panel')},
{down = device_commands.AP_Engage, cockpit_device_id=devices.AFCS, value_down = -1, name = _('Autopilot Off'), category = _('AFCS Control Panel')},
{ combos = {{key = 'A', reformers = {'LAlt'}}}, down=device_commands.AP_Engage_Toggle, cockpit_device_id=devices.AFCS, value_down=0.0, name=_('Autopilot toggle'),	 category=_('AFCS Control Panel')},

-- HOTAS
{ combos = {{key = 'Space', reformers = {'RAlt'}}}, up=device_commands.STICK_Bomb_Release, 				down=device_commands.STICK_Bomb_Release, 	cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, 	name=_('Store Release'),	 category=_('Stick')},
{ up=device_commands.STICK_Trigger_Detent, 				down=device_commands.STICK_Trigger_Detent, 	cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, 	name=_('Trigger First Detent'),	 category=_('Stick')},
{ combos = {{key = 'Space'}}, up=device_commands.STICK_Trigger, 					down=device_commands.STICK_Trigger,		 	cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, 	name=_('Trigger'),	 category=_('Stick')},
{ up=device_commands.STICK_Weapon_Selector_up, 		down=device_commands.STICK_Weapon_Selector_up,		 	cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, 	name=_('Weapon Selector up'),	 category=_('Stick')},
{ up=device_commands.STICK_Weapon_Selector_down, 	down=device_commands.STICK_Weapon_Selector_down,		 	cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, 	name=_('Weapon Selector down'),	 category=_('Stick')},
{ up=device_commands.STICK_Weapon_Selector_press, 	down=device_commands.STICK_Weapon_Selector_press,		 	cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, 	name=_('Weapon Selector press'),	 category=_('Stick')},
{ down=device_commands.STICK_Weapon_Selector, 		cockpit_device_id=devices.WEAPONS, value_down=1.0, 	name=_('Weapon Selector Gun'),	 category=_('Stick')},
{ down=device_commands.STICK_Weapon_Selector, 		cockpit_device_id=devices.WEAPONS, value_down=0.5, 	name=_('Weapon Selector Sparrow or Phoenix Missiles'),	 category=_('Stick')},
{ down=device_commands.STICK_Weapon_Selector, 		cockpit_device_id=devices.WEAPONS, value_down=-0.5, 	name=_('Weapon Selector Sidewinder Missiles'),	 category=_('Stick')},
{ down=device_commands.STICK_Weapon_Selector, 		cockpit_device_id=devices.WEAPONS, value_down=-1.0,	name=_('Weapon Selector Off'),	 category=_('Stick')},
{ up=device_commands.STICK_DLC_ManDec_Thumbwheel,  		pressed=device_commands.STICK_DLC_ManDec_Thumbwheel, 	cockpit_device_id=devices.HOTAS, value_pressed=1.0,  value_up=0,	name=_('DLC Thumbwheel Forward'), 	 category=_('Stick')},
{ up=device_commands.STICK_DLC_ManDec_Thumbwheel,   	pressed=device_commands.STICK_DLC_ManDec_Thumbwheel, 	cockpit_device_id=devices.HOTAS, value_pressed=-1.0, value_up=0,	name=_('DLC Thumbwheel Aft'),	 category=_('Stick')},
{ down=device_commands.STICK_DLC_Toggle_CountDisp,up=device_commands.STICK_DLC_Toggle_CountDisp, 	cockpit_device_id=devices.HOTAS, value_down=1.0,value_up=0.0,		name=_('DLC Toggle / Countermeasure Dispense'),	 category=_('Stick')},
{ down=device_commands.STICK_Autopilot_Emergency_Disconnect, up=device_commands.STICK_Autopilot_Emergency_Disconnect,	cockpit_device_id=devices.AFCS, value_down=1.0,value_up=0.0, 	name=_('Autopilot Emergency Disconnect Paddle'),	 category=_('Stick')},
{ combos = {{key = 'N'}}, down=device_commands.STICK_Autopilot_Ref_NWS_Toggle, up=device_commands.STICK_Autopilot_Ref_NWS_Toggle,	cockpit_device_id=devices.HOTAS, value_down=1.0,value_up=0.0,		name=_('Autopilot Reference / Nosewheel Steering Toggle'),	 category=_('Stick')},

{ up=device_commands.THROTTLE_CAGE_SEAM, down=device_commands.THROTTLE_CAGE_SEAM, cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, name=_('CAGE-SEAM button'),	 category=_('Throttle')},
{ up=device_commands.THROTTLE_PLM, down=device_commands.THROTTLE_PLM, cockpit_device_id=devices.HOTAS, value_up=0.0, value_down=1.0, name=_('PLM button'),	 category=_('Throttle')},

{ down=device_commands.LIGHTS_Exterior_Master_Switch, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Exterior Lights Master Switch OFF'),	 category=_('Throttle')},
{ down=device_commands.LIGHTS_Exterior_Master_Switch, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Exterior Lights Master Switch ON'),	 category=_('Throttle')},
{ down=device_commands.LIGHTS_Exterior_Master_Switch_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Exterior Lights Master Switch Toggle'),	 category=_('Throttle')},
{ down=device_commands.LIGHTS_Exterior_Master_Switch, up=device_commands.LIGHTS_Exterior_Master_Switch, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Exterior Lights Master Switch ON (pressed) / OFF (released)'),	 category=_('Throttle')},

{ up=device_commands.WINGSWEEP_AutoButton, down=device_commands.WINGSWEEP_AutoButton, cockpit_device_id=devices.WINGSWEEP, value_up=0.0, value_down=1.0, name=_('Wing Sweep Auto Mode'),	 category=_('Throttle')},
{ up=device_commands.WINGSWEEP_FwdButton, down=device_commands.WINGSWEEP_FwdButton, cockpit_device_id=devices.WINGSWEEP, value_up=0.0, value_down=1.0, name=_('Wing Sweep Forward'),	 category=_('Throttle')},
{ up=device_commands.WINGSWEEP_AftButton, down=device_commands.WINGSWEEP_AftButton, cockpit_device_id=devices.WINGSWEEP, value_up=0.0, value_down=1.0, name=_('Wing Sweep Aft'),	 category=_('Throttle')},
{ up=device_commands.WINGSWEEP_BombButton, down=device_commands.WINGSWEEP_BombButton, cockpit_device_id=devices.WINGSWEEP, value_up=0.0, value_down=1.0, name=_('Wing Sweep Bomb Mode'),	 category=_('Throttle')},

{cockpit_device_id=devices.ENGINE, down = device_commands.THROTTLE_Left_Throttle_CutOff , up = device_commands.THROTTLE_Left_Throttle_CutOff, value_up=0.0, value_down=1.0,  name = _('Left Engine Cutoff'), category = _('Throttle')},
{cockpit_device_id=devices.ENGINE, down = device_commands.THROTTLE_Right_Throttle_CutOff, up = device_commands.THROTTLE_Right_Throttle_CutOff, value_up=0.0, value_down=1.0, name = _('Right Engine Cutoff'), category = _('Throttle')},

-- pilot display control panel
{ combos={{key='1',reformers={'LShift'}}}, down=device_commands.DISP_mode_takeoff, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode takeoff'), category=_('PDCP')},
{ combos={{key='2',reformers={'LShift'}}}, down=device_commands.DISP_mode_cruise, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode cruise'), category=_('PDCP')},
{ combos={{key='3',reformers={'LShift'}}}, down=device_commands.DISP_mode_air2air, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode air to air'), category=_('PDCP')},
{ combos={{key='4',reformers={'LShift'}}}, down=device_commands.DISP_mode_air2ground, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode air to ground'), category=_('PDCP')},
{ combos={{key='5',reformers={'LShift'}}}, down=device_commands.DISP_mode_landing, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode landing'), category=_('PDCP')},
{ down=device_commands.DISP_mode_next, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode next'), category=_('PDCP')},
{ down=device_commands.DISP_mode_prev, cockpit_device_id=devices.HUD, value_down=1.0, name=_('Display mode previous'), category=_('PDCP')},

{down = device_commands.DISP_VDI_power,     up = device_commands.DISP_VDI_power, value_down = 1, value_up = 0, cockpit_device_id=devices.VDI, name = _('VDI Power On, else Off'), category = _('PDCP')},
{down = device_commands.DISP_VDI_power,     up = device_commands.DISP_VDI_power, value_down = 0, value_up = 1, cockpit_device_id=devices.VDI, name = _('VDI Power Off, else On'), category = _('PDCP')},
{down = device_commands.DISP_VDI_power, cockpit_device_id=devices.VDI, value_down = 1, name = _('VDI Power On'), category = _('PDCP')},
{down = device_commands.DISP_VDI_power, cockpit_device_id=devices.VDI, value_down = 0, name = _('VDI Power Off'), category = _('PDCP')},
{down = device_commands.DISP_VDI_power_toggle, cockpit_device_id=devices.VDI, value_down = 1, name = _('VDI Power Toggle'), category = _('PDCP')},

{down = device_commands.DISP_VDI_display_mode,     up = device_commands.DISP_VDI_display_mode, value_down = 1, value_up = 0, cockpit_device_id=devices.VDI, name = _('VDI Mode TV, else Norm'), category = _('PDCP')},
{down = device_commands.DISP_VDI_display_mode,     up = device_commands.DISP_VDI_display_mode, value_down = 0, value_up = 1, cockpit_device_id=devices.VDI, name = _('VDI Mode Norm, else TV'), category = _('PDCP')},
{down = device_commands.DISP_VDI_display_mode, cockpit_device_id=devices.VDI, value_down = 1, name = _('VDI Mode TV'), category = _('PDCP')},
{down = device_commands.DISP_VDI_display_mode, cockpit_device_id=devices.VDI, value_down = 0, name = _('VDI Mode Norm'), category = _('PDCP')},
{down = device_commands.DISP_VDI_display_mode_toggle, cockpit_device_id=devices.VDI, value_down = 1, name = _('VDI Mode Toggle'), category = _('PDCP')},

{down = device_commands.DISP_VDI_landing_mode,     up = device_commands.DISP_VDI_landing_mode, value_down = 1, value_up = 0, cockpit_device_id=devices.VDI, name = _('VDI AWL ILS, else ACL'), category = _('PDCP')},
{down = device_commands.DISP_VDI_landing_mode,     up = device_commands.DISP_VDI_landing_mode, value_down = 0, value_up = 1, cockpit_device_id=devices.VDI, name = _('VDI AWL ACL, else ILS'), category = _('PDCP')},
{down = device_commands.DISP_VDI_landing_mode, cockpit_device_id=devices.VDI, value_down = 1, name = _('VDI AWL ILS'), category = _('PDCP')},
{down = device_commands.DISP_VDI_landing_mode, cockpit_device_id=devices.VDI, value_down = 0, name = _('VDI AWL ACL'), category = _('PDCP')},
{down = device_commands.DISP_VDI_landing_mode_toggle, cockpit_device_id=devices.VDI, value_down = 1, name = _('VDI ACL/ILS Toggle'), category = _('PDCP')},

{pressed = device_commands.VDIG_VSDI_bright_step, cockpit_device_id=devices.VDI, value_pressed = 0.01, value_up = 0, name = _('VDI Screen Brightness Knob Inc'), category = _('PDCP')},
{pressed = device_commands.VDIG_VSDI_bright_step, cockpit_device_id=devices.VDI, value_pressed = -0.01, value_up = 0, name = _('VDI Screen Brightness Knob Dec'), category = _('PDCP')},
{pressed = device_commands.VDIG_VDI_contrast_step, cockpit_device_id=devices.VDI, value_pressed = 0.01, value_up = 0, name = _('VDI Screen Contrast Inc'), category = _('PDCP')},
{pressed = device_commands.VDIG_VDI_contrast_step, cockpit_device_id=devices.VDI, value_pressed = -0.01, value_up = 0, name = _('VDI Screen Contrast Dec'), category = _('PDCP')},
{pressed = device_commands.VDIG_VSDI_trim_step, cockpit_device_id=devices.VDI, value_pressed = 0.004, value_up = 0, name = _('VDI Trim Inc'), category = _('PDCP')},
{pressed = device_commands.VDIG_VSDI_trim_step, cockpit_device_id=devices.VDI, value_pressed = -0.004, value_up = 0, name = _('VDI Trim Dec'), category = _('PDCP')},

{down = device_commands.DISP_HUD_power,     up = device_commands.DISP_HUD_power, value_down = 1, value_up = 0, cockpit_device_id=devices.HUD, name = _('HUD Power On, else Off'), category = _('PDCP')},
{down = device_commands.DISP_HUD_power,     up = device_commands.DISP_HUD_power, value_down = 0, value_up = 1, cockpit_device_id=devices.HUD, name = _('HUD Power Off, else On'), category = _('PDCP')},
{down = device_commands.DISP_HUD_power, cockpit_device_id=devices.HUD, value_down = 1, name = _('HUD Power On'), category = _('PDCP')},
{down = device_commands.DISP_HUD_power, cockpit_device_id=devices.HUD, value_down = 0, name = _('HUD Power Off'), category = _('PDCP')},
{down = device_commands.DISP_HUD_power_toggle, cockpit_device_id=devices.HUD, value_down = 1, name = _('HUD Power Toggle'), category = _('PDCP')},

{down = device_commands.DISP_HUD_declutter,     up = device_commands.DISP_HUD_declutter, value_down = 1, value_up = 0, cockpit_device_id=devices.HUD, name = _('HUD Declutter On, else Off'), category = _('PDCP')},
{down = device_commands.DISP_HUD_declutter,     up = device_commands.DISP_HUD_declutter, value_down = 0, value_up = 1, cockpit_device_id=devices.HUD, name = _('HUD Declutter Off, else On'), category = _('PDCP')},
{down = device_commands.DISP_HUD_declutter, cockpit_device_id=devices.HUD, value_down = 1, name = _('HUD Declutter On'), category = _('PDCP')},
{down = device_commands.DISP_HUD_declutter, cockpit_device_id=devices.HUD, value_down = 0, name = _('HUD Declutter Off'), category = _('PDCP')},
{down = device_commands.DISP_HUD_declutter_toggle, cockpit_device_id=devices.HUD, value_down = 1, name = _('HUD Declutter Toggle'), category = _('PDCP')},

{down = device_commands.DISP_HUD_AWL_mode,     up = device_commands.DISP_HUD_AWL_mode, value_down = 1, value_up = 0, cockpit_device_id=devices.HUD, name = _('HUD AWL ILS, else ACL'), category = _('PDCP')},
{down = device_commands.DISP_HUD_AWL_mode,     up = device_commands.DISP_HUD_AWL_mode, value_down = 0, value_up = 1, cockpit_device_id=devices.HUD, name = _('HUD AWL ACL, else ILS'), category = _('PDCP')},
{down = device_commands.DISP_HUD_AWL_mode, cockpit_device_id=devices.HUD, value_down = 1, name = _('HUD AWL ILS'), category = _('PDCP')},
{down = device_commands.DISP_HUD_AWL_mode, cockpit_device_id=devices.HUD, value_down = 0, name = _('HUD AWL ACL'), category = _('PDCP')},
{down = device_commands.DISP_HUD_AWL_mode_toggle, cockpit_device_id=devices.HUD, value_down = 1, name = _('HUD ACL/ILS Toggle'), category = _('PDCP')},

{pressed = device_commands.VDIG_HUD_bright_step, cockpit_device_id=devices.HUD, value_pressed = 0.01, value_up = 0, name = _('HUD Brightness Knob Inc'), category = _('PDCP')},
{pressed = device_commands.VDIG_HUD_bright_step, cockpit_device_id=devices.HUD, value_pressed = -0.01, value_up = 0, name = _('HUD Brightness Knob Dec'), category = _('PDCP')},
{pressed = device_commands.VDIG_HUD_trim_step, cockpit_device_id=devices.HUD, value_pressed = 0.002, value_up = 0, name = _('HUD Trim Inc'), category = _('PDCP')},
{pressed = device_commands.VDIG_HUD_trim_step, cockpit_device_id=devices.HUD, value_pressed = -0.002, value_up = 0, name = _('HUD Trim Dec'), category = _('PDCP')},

{down = device_commands.VDIG_VDI_handle, up = device_commands.VDIG_VDI_handle, cockpit_device_id=devices.HUD, value_down = 1.0, value_up = 0.0, name = _('HUD Filter pulled else pushed'), category = _('PDCP')},
{down = device_commands.VDIG_VDI_handle_toggle, cockpit_device_id=devices.HUD, value_down = 1.0, name = _('HUD Filter toggle'), category = _('PDCP')},

{down = device_commands.DISP_HSD_ECMD_power,     up = device_commands.DISP_HSD_ECMD_power, value_down = 1, value_up = 0, cockpit_device_id=devices.HSD, name = _('HSD/ECM Power On, else Off'), category = _('PDCP')},
{down = device_commands.DISP_HSD_ECMD_power,     up = device_commands.DISP_HSD_ECMD_power, value_down = 0, value_up = 1, cockpit_device_id=devices.HSD, name = _('HSD/ECM Power Off, else On'), category = _('PDCP')},
{down = device_commands.DISP_HSD_ECMD_power, cockpit_device_id=devices.HSD, value_down = 1, name = _('HSD/ECM Power On'), category = _('PDCP')},
{down = device_commands.DISP_HSD_ECMD_power, cockpit_device_id=devices.HSD, value_down = 0, name = _('HSD/ECM Power Off'), category = _('PDCP')},
{down = device_commands.DISP_HSD_ECMD_power_toggle, cockpit_device_id=devices.HSD, value_down = 1, name = _('HSD/ECM Power Toggle'), category = _('PDCP')},

{down = device_commands.HSD_Display_Mode_Cycle,     up = device_commands.HSD_Display_Mode_Cycle, value_down = 1, value_up = 0, cockpit_device_id=devices.HSD, name = _('HSD Mode NAV, else TID'), category = _('PDCP')},
{down = device_commands.HSD_Display_Mode_Cycle,     up = device_commands.HSD_Display_Mode_Cycle, value_down = 0, value_up = 1, cockpit_device_id=devices.HSD, name = _('HSD Mode TID, else NAV'), category = _('PDCP')},
{down = device_commands.HSD_Display_Mode_Cycle, cockpit_device_id=devices.HSD, value_down = 1, name = _('HSD Mode NAV'), category = _('PDCP')},
{down = device_commands.HSD_Display_Mode_Cycle, cockpit_device_id=devices.HSD, value_down = 0, name = _('HSD Mode TID'), category = _('PDCP')},
{down = device_commands.HSD_Display_Mode_Cycle_toggle, cockpit_device_id=devices.HSD, value_down = 1, name = _('HSD mode Toggle'), category = _('PDCP')},

{pressed = device_commands.HSD_Knob_Course, cockpit_device_id=devices.HSD, value_pressed = 0.001, value_up = 0, name = _('HSD Course Knob Inc'), category = _('PDCP')},
{pressed = device_commands.HSD_Knob_Course, cockpit_device_id=devices.HSD, value_pressed = -0.001, value_up = 0, name = _('HSD Course Knob Dec'), category = _('PDCP')},
{pressed = device_commands.HSD_Knob_Heading, cockpit_device_id=devices.HSD, value_pressed = 0.0015, value_up = 0, name = _('HSD Heading Knob Inc'), category = _('PDCP')},
{pressed = device_commands.HSD_Knob_Heading, cockpit_device_id=devices.HSD, value_pressed = -0.0015, value_up = 0, name = _('HSD Heading Knob Dec'), category = _('PDCP')},
{pressed = device_commands.HSD_Knob_Brightness_IncDec, cockpit_device_id=devices.HSD, value_pressed = 0.01, value_up = 0, name = _('HSD Brightness Knob Inc'), category = _('PDCP')},
{pressed = device_commands.HSD_Knob_Brightness_IncDec, cockpit_device_id=devices.HSD, value_pressed = -0.01, value_up = 0, name = _('HSD Brightness Knob Dec'), category = _('PDCP')},

{down = device_commands.HSD_ECM_Override,     up = device_commands.HSD_ECM_Override, value_down = 1, value_up = 0, cockpit_device_id=devices.HSD, name = _('HSD ECM Override On, else Off'), category = _('PDCP')},
{down = device_commands.HSD_ECM_Override,     up = device_commands.HSD_ECM_Override, value_down = 0, value_up = 1, cockpit_device_id=devices.HSD, name = _('HSD ECM Override Off, else On'), category = _('PDCP')},
{down = device_commands.HSD_ECM_Override, cockpit_device_id=devices.HSD, value_down = 1, name = _('HSD ECM Override On'), category = _('PDCP')},
{down = device_commands.HSD_ECM_Override, cockpit_device_id=devices.HSD, value_down = 0, name = _('HSD ECM Override Off'), category = _('PDCP')},
{down = device_commands.HSD_ECM_Override_toggle, cockpit_device_id=devices.HSD, value_down = 0, name = _('HSD ECM Override Toggle'), category = _('PDCP')},

{down = device_commands.HSD_Btn_Test, up = device_commands.HSD_Btn_Test, cockpit_device_id=devices.HSD, value_down = 1.0, value_up = 0.0, name = _('HSD Test Button'), category = _('PDCP')},

{down = device_commands.NAV_Btn_Steer_TCN,     up = device_commands.NAV_Btn_Steer_TCN, value_down = 1, value_up = 0, cockpit_device_id=devices.NAV_INTERFACE, name = _('STEER CMD TACAN'), category = _('PDCP')},
{down = device_commands.NAV_Btn_Steer_DEST,     up = device_commands.NAV_Btn_Steer_DEST, value_down = 1, value_up = 0, cockpit_device_id=devices.NAV_INTERFACE, name = _('STEER CMD Destination'), category = _('PDCP')},
{down = device_commands.NAV_Btn_Steer_AWL_PCD,     up = device_commands.NAV_Btn_Steer_AWL_PCD, value_down = 1, value_up = 0, cockpit_device_id=devices.NAV_INTERFACE, name = _('STEER CMD AWL/PCD'), category = _('PDCP')},
{down = device_commands.NAV_Btn_Steer_VEC,     up = device_commands.NAV_Btn_Steer_VEC, value_down = 1, value_up = 0, cockpit_device_id=devices.NAV_INTERFACE, name = _('STEER CMD VEC'), category = _('PDCP')},
{down = device_commands.NAV_Btn_Steer_MAN,     up = device_commands.NAV_Btn_Steer_MAN, value_down = 1, value_up = 0, cockpit_device_id=devices.NAV_INTERFACE, name = _('STEER CMD MAN'), category = _('PDCP')},

-- Master WLP_Master_Caution_RIO
{combos = {{key = 'M', reformers = {'LAlt'}}} , 			down=device_commands.WLP_Master_Caution_Pilot, 	up=device_commands.WLP_Master_Caution_Pilot, cockpit_device_id=devices.WARNINGLIGHTS, value_down=1.0, value_up=0.0, name = _('Master Caution Reset'), category = _('ACM Panel')},
{ down=device_commands.WEAP_ACM_Cover_Toggle, cockpit_device_id=devices.WEAPONS, value_down=1.0, name=_('ACM cover toggle'), category=_('ACM Panel')},
{ down=device_commands.WEAP_ACM_Cover, cockpit_device_id=devices.WEAPONS, value_down=1.0, name=_('ACM cover open'), category=_('ACM Panel')},
{ down=device_commands.WEAP_ACM_Cover, cockpit_device_id=devices.WEAPONS, value_down=0.0, name=_('ACM cover close'), category=_('ACM Panel')},


-- Trimmer


-- Airbrake
{combos={{key='B',reformers={'LCtrl'}}},			up=device_commands.SPEEDBRAKE_ExtendRetract, pressed=device_commands.SPEEDBRAKE_ExtendRetract, 	cockpit_device_id=devices.GEARHOOK, value_up=0.0, value_pressed=1.0, 	name=_('Speed brake extend'),category=_('Gears, brakes, and hook')},
{combos={{key='B',reformers={'LShift'}}},			up=device_commands.SPEEDBRAKE_ExtendRetract, pressed=device_commands.SPEEDBRAKE_ExtendRetract, 	cockpit_device_id=devices.GEARHOOK, value_up=0.0, value_pressed=-1.0,	name=_('Speed brake retract'),category=_('Gears, brakes, and hook')},
{combos={{key='B'}}, down=device_commands.SPEEDBRAKE_Toggle, 	cockpit_device_id=devices.GEARHOOK, value_down=1.0,	name=_('Speed brake toggle'),category=_('Gears, brakes, and hook')},

-- parking brake
{up=device_commands.BRAKE_ParkingBrake, down=device_commands.BRAKE_ParkingBrake, 	cockpit_device_id=devices.GEARHOOK, value_up=1.0, value_down=0.0,	name=_('Parking brake enabled, else disabed'),category=_('Gears, brakes, and hook')},
{combos = {{key = 'P',	reformers = {'RCtrl'}}}, down=device_commands.BRAKE_ParkingBrake, 	cockpit_device_id=devices.GEARHOOK, value_down=0.0,	name=_('Parking brake pull'),category=_('Gears, brakes, and hook')},
{combos = {{key = 'P',	reformers = {'RAlt'}}}, down=device_commands.BRAKE_ParkingBrake, 	cockpit_device_id=devices.GEARHOOK, value_down=1.0,	name=_('Parking brake stow'),category=_('Gears, brakes, and hook')},

-- Flaps
{combos = {{key = 'F'}}, 									down=device_commands.FLAPS_Lever, 	cockpit_device_id=devices.FLAPS, value_down=0.0, name = _('Flaps Down'), category = _('Flight Control')},
{combos = {{key = 'F', reformers = {'LShift'}}} , 			down=device_commands.FLAPS_Lever, 	cockpit_device_id=devices.FLAPS, value_down=1.0, name = _('Flaps Up'), category = _('Flight Control')},
{combos = {{key = 'F', reformers = {'LCtrl'}}}, 			down=device_commands.FLAPS_Lever, 	cockpit_device_id=devices.FLAPS, value_down=-1, name = _('Emergency Flaps Down'), category = _('Flight Control')},
{combos = {{key = 'F', reformers = {'LCtrl','LShift'}}} , 	down=device_commands.FLAPS_Lever, 	cockpit_device_id=devices.FLAPS, value_down=2.0, name = _('Emergency Flaps Up'), category = _('Flight Control')},

-- ACM Panel
{ down=device_commands.WEAP_Master_Arm_Cover, cockpit_device_id=devices.WEAPONS, value_down=-1.0, name=_('Master arm cover toggle'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Master_Arm_Cover, cockpit_device_id=devices.WEAPONS, value_down=1.0, name=_('Master arm cover open'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Master_Arm_Cover, cockpit_device_id=devices.WEAPONS, value_down=0.0, name=_('Master arm cover close'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Master_Arm_And_Cover, cockpit_device_id=devices.WEAPONS, value_down=1.0, name=_('Master arm on and cover open'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Master_Arm_And_Cover, cockpit_device_id=devices.WEAPONS, value_down=0.0, name=_('Master arm off and cover close'), category=_('ACM Panel')},
{down = device_commands.WEAP_Master_Arm_And_Cover,     up = device_commands.WEAP_Master_Arm_And_Cover, value_down = 1, value_up = 0, cockpit_device_id=devices.WEAPONS, name = _('Master Arm On and Cover Open, else Safe and Closed'), category = _('ACM Panel')},
{down = device_commands.WEAP_Master_Arm_And_Cover,     up = device_commands.WEAP_Master_Arm_And_Cover, value_down = 0, value_up = 1, cockpit_device_id=devices.WEAPONS, name = _('Master Arm Safe and Cover Closed, else Open and Armed'), category = _('ACM Panel')},

{down = device_commands.WEAP_ACM_Cover,     up = device_commands.WEAP_ACM_Cover, value_down = 1, value_up = 0, cockpit_device_id=devices.WEAPONS, name = _('ACM Cover Open, else Closed'), category = _('ACM Panel')},
{down = device_commands.WEAP_ACM_Cover,     up = device_commands.WEAP_ACM_Cover, value_down = 0, value_up = 1, cockpit_device_id=devices.WEAPONS, name = _('ACM Cover Closed, else Open'), category = _('ACM Panel')},

{ combos = {{key = 'W', reformers = {'LCtrl'}}}, down=device_commands.WEAP_Emer_Jettison, up=device_commands.WEAP_Emer_Jettison, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Emergency Jettison'), category=_('Weapons')},
{ down=device_commands.WEAP_ACM_Jettison, up=device_commands.WEAP_ACM_Jettison, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('ACM Jettison'), category=_('ACM Panel')},
{ down=device_commands.WEAP_MSL_Mode, up=device_commands.WEAP_MSL_Mode, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Missile mode toggle'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Gun_Rate, up=device_commands.WEAP_Gun_Rate, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Gun rate toggle'), category=_('ACM Panel')},
{ down=device_commands.WEAP_SW_Cool, up=device_commands.WEAP_SW_Cool, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('AIM-9 cooling toggle'), category=_('ACM Panel')},
{ down=device_commands.WEAP_MSL_Prep, up=device_commands.WEAP_MSL_Prep, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Missile prepare toggle'), category=_('ACM Panel')},

{ down=device_commands.WEAP_Master_Arm, cockpit_device_id=devices.WEAPONS, value_down=-1.0, name=_('Master arm on'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Master_Arm, cockpit_device_id=devices.WEAPONS, value_down=0.0, name=_('Master arm off'), category=_('ACM Panel')},
{ down=device_commands.WEAP_Master_Arm, cockpit_device_id=devices.WEAPONS, value_down=1.0, name=_('Master arm training'), category=_('ACM Panel')},

{ down=device_commands.WEAP_Target_designate_up, up=device_commands.WEAP_Target_designate_up, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Target designate up / VSL HI'), category=_('Left sidewall')},
{ down=device_commands.WEAP_Target_designate_fwd, up=device_commands.WEAP_Target_designate_fwd, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Target designate fwd / PAL'), category=_('Left sidewall')},
{ down=device_commands.WEAP_Target_designate_down, up=device_commands.WEAP_Target_designate_down, cockpit_device_id=devices.WEAPONS, value_down=1.0, value_up=0.0, name=_('Target designate down / VSL LO'), category=_('Left sidewall')},





--************************************* Jester AI  ******************************************************************

--Menu
{combos = {{key = 'A'}},		 cockpit_device_id=devices.JESTERAI, up =device_commands.JESTER_ToggleMenu ,down=device_commands.JESTER_ToggleMenu, value_up=-1.0, value_down=1.0,	name=_('Toggle Menu'),	 category=_('Jester AI')},
{combos = {{key = '1',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command1, value_down=1.0,	name=_('Command 1'),	 category=_('Jester AI')},
{combos = {{key = '2',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command2, value_down=1.0,	name=_('Command 2'),	 category=_('Jester AI')},
{combos = {{key = '3',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command3, value_down=1.0,	name=_('Command 3'),	 category=_('Jester AI')},
{combos = {{key = '4',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command4, value_down=1.0,	name=_('Command 4'),	 category=_('Jester AI')},
{combos = {{key = '5',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command5, value_down=1.0,	name=_('Command 5'),	 category=_('Jester AI')},
{combos = {{key = '6',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command6, value_down=1.0,	name=_('Command 6'),	 category=_('Jester AI')},
{combos = {{key = '7',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command7, value_down=1.0,	name=_('Command 7'),	 category=_('Jester AI')},
{combos = {{key = '8',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command8, value_down=1.0,	name=_('Command 8'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuHorizontal, up=device_commands.JESTER_MenuHorizontal, value_down=-1.0, value_up=0.0, name=_('Jester Menu Left'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuHorizontal, up=device_commands.JESTER_MenuHorizontal, value_down=1.0, value_up=0.0, name=_('Jester Menu Right'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuVertical, up=device_commands.JESTER_MenuVertical, value_down=1.0, value_up=0.0, name=_('Jester Menu Up'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuVertical, up=device_commands.JESTER_MenuVertical, value_down=-1.0, value_up=0.0, name=_('Jester Menu Down'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuDiag45, up=device_commands.JESTER_MenuDiag45, value_down=-1.0, value_up=0.0, name=_('Jester Menu Down Left'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuDiag45, up=device_commands.JESTER_MenuDiag45, value_down=1.0, value_up=0.0, name=_('Jester Menu Up Right'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuDiag135, up=device_commands.JESTER_MenuDiag135, value_down=1.0, value_up=0.0, name=_('Jester Menu Down Right'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_MenuDiag135, up=device_commands.JESTER_MenuDiag135, value_down=-1.0, value_up=0.0, name=_('Jester Menu Up Left'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Check, value_down=1.0,  name=_('Check'),	 category=_('Jester AI')},
{cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_LoudAndClear, value_down=1.0, name=_('Loud and Clear'),	 category=_('Jester AI')},
{combos = {{key = 'A',reformers={'LShift'}}},		cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_CloseMenu, value_down=1.0,  name=_('Close Menu'),	 category=_('Jester AI')},

-- Nav related commands
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_SP1, value_down=1.0,	name=_('Nav - Set Steerpoint SP 1'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_SP2, value_down=1.0,	name=_('Nav - Set Steerpoint SP 2'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_SP3, value_down=1.0,	name=_('Nav - Set Steerpoint SP 3'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_FP , value_down=1.0,	name=_('Nav - Set Steerpoint Fixed Point'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_IP , value_down=1.0,	name=_('Nav - Set Steerpoint Initial Point'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_ST , value_down=1.0,	name=_('Nav - Set Steerpoint Surface Target'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_HB , value_down=1.0,	name=_('Nav - Set Steerpoint Home Base'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Steerpoint_MAN, value_down=1.0,	name=_('Nav - Set Steerpoint Man'),	 category=_('Jester AI')},

-- Radar related Commands
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_VSL_High , value_down=1.0,	name=_('Radar - VSL High'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_VSL_Low, value_down=1.0,	name=_('Radar - VSL Low'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_TogglePDorPStt, value_down=1.0,	name=_('Radar - Toggle PD-STT or P-STT'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_BreakLock, value_down=1.0,	name=_('Radar - Break Lock'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Range_Auto, value_down=1.0,	name=_('Radar - Range Auto'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Range_25 , value_down=1.0,	name=_('Radar - Range 25'),	     category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Range_50 , value_down=1.0,	name=_('Radar - Range 50'),	     category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Range_100, value_down=1.0,	name=_('Radar - Range 100'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Range_200, value_down=1.0,	name=_('Radar - Range 200'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Range_400, value_down=1.0,	name=_('Radar - Range 400'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Lock_Ahead, value_down=1.0,	name=_('Radar - STT Lock Ahead'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Lock_Ahead_Enemy, value_down=1.0,	name=_('Radar - STT Lock Enemy Ahead'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Lock_Ahead_Friendly, value_down=1.0,	name=_('Radar - STT Lock Friendly Ahead'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Ground_Stabilize, value_down=1.0,	name=_('Radar - Ground Stabilize'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Aircraft_Stabilize, value_down=1.0,	name=_('Radar - Aircraft Stabilize'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Radar_TWS, value_down=1.0,	name=_('Radar - TWS Mode'),	 category=_('Jester AI')},
{ cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Radar_RWS, value_down=1.0,	name=_('Radar - RWS Mode'),	 category=_('Jester AI')},









--************************************* GEARS, G. Brakes and Drag chute  ******************************************************************

-- Gears
--{combos={{key='G'}}, 								down=device_commands.GEAR_Handle, 	cockpit_device_id=devices.GEARHOOK, value_down=1.0,	name='Gear Toggle',			category='Gears, brakes, and hook'},
{combos={{key='G',reformers={'LCtrl'}}},			down=device_commands.GEAR_Handle, 	cockpit_device_id=devices.GEARHOOK, value_down=1.0, 	name=_('Gears Down'),			 category=_('Gears, brakes, and hook')},
{combos={{key='G',reformers={'LShift'}}},			down=device_commands.GEAR_Handle, 	cockpit_device_id=devices.GEARHOOK, value_down=0,		name=_('Gears Up'),			 category=_('Gears, brakes, and hook')},
{combos={{key='G',reformers={'LCtrl','LShift'}}},	down=device_commands.GEAR_Handle,	cockpit_device_id=devices.GEARHOOK,	value_down=-1.0,	name=_('Gear Emergency Extend'),category=_('Gears, brakes, and hook')},
{combos={{key='G'}},								down=device_commands.GEAR_Toggle, 	cockpit_device_id=devices.GEARHOOK, value_down=0,		name=_('Gears Toggle'),			 category=_('Gears, brakes, and hook')},

{down = device_commands.GEAR_Handle,     up = device_commands.GEAR_Handle, value_down = 1, value_up = 0, cockpit_device_id=devices.GEARHOOK, name = _('Gear Down, else Up'), category = _('Gears, brakes, and hook')},
{down = device_commands.GEAR_Handle,     up = device_commands.GEAR_Handle, value_down = 0, value_up = 1, cockpit_device_id=devices.GEARHOOK, name = _('Gear Up, else Down'), category = _('Gears, brakes, and hook')},

--Hook
{combos={{key='H',reformers={'LCtrl'}}},			down=device_commands.HOOK_Handle,cockpit_device_id=devices.GEARHOOK,	value_down=1.0,	name=_('Hook Extend'),category=_('Gears, brakes, and hook')},
{combos={{key='H',reformers={'LShift'}}},			down=device_commands.HOOK_Handle,cockpit_device_id=devices.GEARHOOK,	value_down=0,	name=_('Hook Retract'),category=_('Gears, brakes, and hook')},
{combos={{key='H'}}, down=device_commands.HOOK_Toggle,cockpit_device_id=devices.GEARHOOK,	value_down=1.0,	name=_('Hook Toggle'),category=_('Gears, brakes, and hook')},
{down = device_commands.HOOK_Handle,     up = device_commands.HOOK_Handle, value_down = 1, value_up = 0, cockpit_device_id=devices.GEARHOOK, name = _('Hook Extend, else Retract'), category = _('Gears, brakes, and hook')},
{down = device_commands.HOOK_Handle,     up = device_commands.HOOK_Handle, value_down = 0, value_up = 1, cockpit_device_id=devices.GEARHOOK, name = _('Hook Retract, else Extend'), category = _('Gears, brakes, and hook')},


-- Wheel brake
{combos={{key='W'}},			up=iCommandWheelBrake, pressed=iCommandWheelBrake, 			 value_up=-1.0, value_pressed=1.0,	name=_('Wheel Brake both'),  category=_('Gears, brakes, and hook')},
{								up=iCommandLeftWheelBrake, pressed=iCommandLeftWheelBrake, 	 value_up=-1.0, value_pressed=1.0,	name=_('Wheel Brake Left'),  category=_('Gears, brakes, and hook')},
{								up=iCommandRightWheelBrake, pressed=iCommandRightWheelBrake, value_up=-1.0, value_pressed=1.0,	name=_('Wheel Brake Right'), category=_('Gears, brakes, and hook')},



{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, cockpit_device_id=devices.GEARHOOK, value_down = 1,  name = _('Antiskid & Spoiler BK - Both'), category = _('Gears, brakes, and hook')},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, cockpit_device_id=devices.GEARHOOK, value_down = 0,  name = _('Antiskid & Spoiler BK - Off'), category = _('Gears, brakes, and hook')},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, cockpit_device_id=devices.GEARHOOK, value_down = -1, name = _('Antiskid & Spoiler BK - Spoiler Only'), category = _('Gears, brakes, and hook')},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, up = device_commands.BRAKE_AntiSkidAndSpoilerBrake, value_down = -1, value_up = 0, cockpit_device_id=devices.GEARHOOK, name = _('Anti Skid Spoiler BK Switch Spoiler BK, else OFF'), category = _('Gears, brakes, and hook')},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake, up = device_commands.BRAKE_AntiSkidAndSpoilerBrake, value_down = 1, value_up = 0, cockpit_device_id=devices.GEARHOOK, name = _('Anti Skid Spoiler BK Switch BOTH, else OFF'), category = _('Gears, brakes, and hook')},
{down = device_commands.BRAKE_AntiSkidAndSpoilerBrake_toggle, value_down = 1, cockpit_device_id=devices.GEARHOOK, name = _('Antiskid & Spoiler BK - Toggle'), category = _('Gears, brakes, and hook')},


--*************** RWR *****************************
{pressed = device_commands.RWR_Brightness_Pilot_Step, cockpit_device_id = devices.RWR, value_pressed = 1.0, value_up = 0, name = _('RWR Brightness Pilot Inc'), category = _('RWR')},
{pressed = device_commands.RWR_Brightness_Pilot_Step, cockpit_device_id = devices.RWR, value_pressed = -1.0, value_up = 0, name = _('RWR Brightness Pilot Dec'), category = _('RWR')},

--*************** Nav Wpt *********************
{combos = {{key = '`', reformers = {'LCtrl'}}}, down = device_commands.Mission_WPT_Next, cockpit_device_id=devices.NAV_INTERFACE, value_down = 1, value_up = 0, name = _('Next Waypoint'), category = _('Navigation')},
{combos = {{key = '`', reformers = {'LShift'}}}, down = device_commands.Mission_WPT_Prev, cockpit_device_id=devices.NAV_INTERFACE, value_down = 1, value_up = 0, name = _('Previous Waypoint'), category = _('Navigation')},


--**************************************--
---Cockpit mechanics
{combos = {{key='E',reformers={'LShift'}}}, down = device_commands.EJECT_ArmPilotToggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down = -1, name = _('Toggle Arm Ejection Seat'), category = _('Cockpit Mechanics')},

{combos = {{key='Back'}}, down = device_commands.STICK_ShowHideToggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down = 1, name = _('Control Stick Show/Hide'), category = _('Cheat')},
{down = device_commands.STICK_ShowHide, cockpit_device_id=devices.COCKPITMECHANICS, value_down = 0, name = _('Control Stick Show'), category = _('Cheat')},
{down = device_commands.STICK_ShowHide, cockpit_device_id=devices.COCKPITMECHANICS, value_down = 1, name = _('Control Stick Hide'), category = _('Cheat')},
{down = device_commands.STICK_ShowHide, up = device_commands.STICK_ShowHide, cockpit_device_id=devices.COCKPITMECHANICS, value_down = 0, value_up = 1, name = _('Control Stick Show, else Hide'), category = _('Cheat')},

--***************************************** Lights *************************************************************
{ down=device_commands.LIGHTS_PositionWings, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Position Wing OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionWings, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Position Wing BRT'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionWings, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1.0, name=_('Lights Position Wing DIM'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionWings_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Position Wing Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionTail, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Position Tail OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionTail, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Position Tail BRT'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionTail, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1.0, name=_('Lights Position Tail DIM'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionTail_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Position Tail Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionFlash, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Position STEADY'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionFlash, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Position FLASH'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_PositionFlash_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Position FLASH/STEADY Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_AntiCol, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Anti Collision OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_AntiCol, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Anti Collision ON'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_AntiCol_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Anti Collision Toggle'),	 category=_('Lights')},
{ down=device_commands.AoA_HookBypass, cockpit_device_id=devices.AOASYSTEM, value_down=0.0, name=_('Lights Hook Bypass CARRIER'),	 category=_('Lights')},
{ down=device_commands.AoA_HookBypass, cockpit_device_id=devices.AOASYSTEM, value_down=1.0, name=_('Lights Hook Bypass FIELD'),	 category=_('Lights')},
{ down=device_commands.AoA_HookBypass_Toggle, cockpit_device_id=devices.AOASYSTEM, value_down=1.0, value_up=0.0, name=_('Lights Hook Bypass Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_Taxi, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Taxi OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_Taxi, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Taxi ON'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_Taxi_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Taxi Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights White Flood OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights White Flood BRT'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1.0, name=_('Lights White Flood DIM'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights White Flood Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Red Flood OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Red Flood BRT'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1.0, name=_('Lights Red Flood DIM'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Red Flood Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_ACMPanel_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1, value_up=0, name = _('Lights ACM Brightnes Up'), category = _('Lights')},
{ down=device_commands.LIGHTS_ACMPanel_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1, value_up=0, name = _('Lights ACM Brightnes Down'), category = _('Lights')},
{ down=device_commands.AoA_IndexerStrength_Step, cockpit_device_id=devices.AOASYSTEM, value_down=1, value_up=0, name = _('Lights Indexer Brightnes Up'), category = _('Lights')},
{ down=device_commands.AoA_IndexerStrength_Step, cockpit_device_id=devices.AOASYSTEM, value_down=-1, value_up=0, name = _('Lights Indexer Brightnes Down'), category = _('Lights')},
{ down=device_commands.LIGHTS_Instruments_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1, value_up=0, name = _('Lights Instrument Brightnes Up'), category = _('Lights')},
{ down=device_commands.LIGHTS_Instruments_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1, value_up=0, name = _('Lights Instrument Brightnes Down'), category = _('Lights')},
{ down=device_commands.LIGHTS_Console_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1, value_up=0, name = _('Lights Console Brightnes Up'), category = _('Lights')},
{ down=device_commands.LIGHTS_Console_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1, value_up=0, name = _('Lights Console Brightnes Down'), category = _('Lights')},
{ down=device_commands.LIGHTS_Formation_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1, value_up=0, name = _('Lights Formation Brightnes Up'), category = _('Lights')},
{ down=device_commands.LIGHTS_Formation_Step, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1, value_up=0, name = _('Lights Formation Brightnes Down'), category = _('Lights')},

--***************************************** Radio *************************************************************
{combos = {{key = '\\', reformers = {'RAlt'}}}, down = device_commands.RADIO_ICS_Button_UHF1_Pilot, up = device_commands.RADIO_ICS_Button_UHF1_Pilot, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('Mic Button UHF1 (ARC-159)'), category = _('Radio')},
{combos = {{key = '\\', reformers = {'RCtrl'}}}, down = device_commands.RADIO_ICS_Button_UHF2_Pilot, up = device_commands.RADIO_ICS_Button_UHF2_Pilot, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('Mic Button UHF2 (ARC-182)'), category = _('Radio')},
{combos = {{key = '\\', reformers = {'RShift'}}},down=device_commands.RADIO_ICS_Button_ICS_Pilot, up=device_commands.RADIO_ICS_Button_ICS_Pilot, cockpit_device_id=devices.ICS, value_down=1.0, value_up=0.0, name=_('Mic Button ICS'), category=_('Radio')},

{down = device_commands.RADIO_ICS_Button_UHF1_Pilot_Export_Only, up = device_commands.RADIO_ICS_Button_UHF1_Pilot_Export_Only, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('Mic Button UHF1 (ARC-159) - SRS or VoIP Only / No Menu'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Button_UHF2_Pilot_Export_Only, up = device_commands.RADIO_ICS_Button_UHF2_Pilot_Export_Only, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('Mic Button UHF2 (ARC-182) - SRS or VoIP Only / No Menu'), category = _('Radio')},
{down=device_commands.RADIO_ICS_Button_ICS_Pilot_Export_Only, up=device_commands.RADIO_ICS_Button_ICS_Pilot_Export_Only, cockpit_device_id=devices.ICS, value_down=1.0, value_up=0.0, name=_('Mic Button ICS - SRS or VoIP Only / No Menu'), category=_('Radio')},
-- ARC-159
{pressed = device_commands.RADIO_UHF_VOL_STEP_Pilot, cockpit_device_id = devices.ARC159, value_pressed = 1.0, value_up = 0, name = _('UHF ARC-159 Volume Pilot Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_VOL_STEP_Pilot, cockpit_device_id = devices.ARC159, value_pressed = -1.0, value_up = 0, name = _('UHF ARC-159 Volume Pilot Dec'), category = _('Radio')},
{down = device_commands.RADIO_UHF_SQL_TOGGLE_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 Squelch Toggle'), category = _('Radio')},
{down = device_commands.RADIO_UHF_SQL_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, name = _('UHF ARC-159 Squelch SQL'), category = _('Radio')},
{down = device_commands.RADIO_UHF_SQL_Pilot, cockpit_device_id = devices.ARC159, value_down = 0, name = _('UHF ARC-159 Squelch OFF'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_HUNDRED_TEN_Pilot, up = device_commands.RADIO_UHF_FREQ_HUNDRED_TEN_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 10 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_HUNDRED_TEN_Pilot, up = device_commands.RADIO_UHF_FREQ_HUNDRED_TEN_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 10 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_UNIT_Pilot, up = device_commands.RADIO_UHF_FREQ_UNIT_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 1 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_UNIT_Pilot, up = device_commands.RADIO_UHF_FREQ_UNIT_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 1 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_TEHTH_Pilot, up = device_commands.RADIO_UHF_FREQ_TEHTH_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 0.1 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_TEHTH_Pilot, up = device_commands.RADIO_UHF_FREQ_TEHTH_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 0.1 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_HUNDREDTH_Pilot, up = device_commands.RADIO_UHF_FREQ_HUNDREDTH_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 0.025 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_HUNDREDTH_Pilot, up = device_commands.RADIO_UHF_FREQ_HUNDREDTH_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 0.025 MHz Switch Down'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_BRT_STEP_Pilot, cockpit_device_id = devices.ARC159, value_pressed = 1.0, value_up = 0, name = _('UHF ARC-159 BRT Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_BRT_STEP_Pilot, cockpit_device_id = devices.ARC159, value_pressed = -1.0, value_up = 0, name = _('UHF ARC-159 BRT Dec'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_Remote_DISP_BRT_STEP_Pilot, cockpit_device_id = devices.ARC159, value_pressed = 1.0, value_up = 0, name = _('UHF ARC-159 Remote BRT Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_Remote_DISP_BRT_STEP_Pilot, cockpit_device_id = devices.ARC159, value_pressed = -1.0, value_up = 0, name = _('UHF ARC-159 Remote BRT Dec'), category = _('Radio')},
{down = device_commands.RADIO_UHF_Remote_DISP_TEST_Pilot, up = device_commands.RADIO_UHF_Remote_DISP_TEST_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0, value_up = 0,name = _('UHF ARC-159 Remote TEST'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FUNC_Pilot, cockpit_device_id = devices.ARC159, value_down = 0.0, name = _('UHF ARC-159 Function OFF'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FUNC_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0/3.0, name = _('UHF ARC-159 Function MAIN'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FUNC_Pilot, cockpit_device_id = devices.ARC159, value_down = 2.0/3.0, name = _('UHF ARC-159 Function BOTH'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FUNC_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0, name = _('UHF ARC-159 Function ADF'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FUNC_STEP_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 Function Inc'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FUNC_STEP_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 Function Dec'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_MODE_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0, name = _('UHF ARC-159 Mode GUARD'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_MODE_Pilot, cockpit_device_id = devices.ARC159, value_down = 0.5, name = _('UHF ARC-159 Mode MANUAL'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_MODE_Pilot, cockpit_device_id = devices.ARC159, value_down = 0.0, name = _('UHF ARC-159 Mode PRESET'), category = _('Radio')},
{down = device_commands.RADIO_UHF_READ_Pilot, up = device_commands.RADIO_UHF_READ_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0, value_up = 0,name = _('UHF ARC-159 READ'), category = _('Radio')},
{down = device_commands.RADIO_UHF_LOAD_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0, value_up = 0,name = _('UHF ARC-159 LOAD'), category = _('Radio')},
{down = device_commands.RADIO_UHF_TONE_Pilot, up = device_commands.RADIO_UHF_TONE_Pilot, cockpit_device_id = devices.ARC159, value_down = 1.0, value_up = 0,name = _('UHF ARC-159 TONE'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_MODE_STEP_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 Mode Inc'), category = _('Radio')},
{down = device_commands.RADIO_UHF_FREQ_MODE_STEP_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 Mode Dec'), category = _('Radio')},
{down = device_commands.RADIO_UHF_CHAN_STEP_Pilot, cockpit_device_id = devices.ARC159, value_down = 1, value_up = 0, name = _('UHF ARC-159 CHAN SEL Inc'), category = _('Radio')},
{down = device_commands.RADIO_UHF_CHAN_STEP_Pilot, cockpit_device_id = devices.ARC159, value_down = -1, value_up = 0, name = _('UHF ARC-159 CHAN SEL Dec'), category = _('Radio')},

-- ARC-182
{pressed = device_commands.RADIO_VHF_VOL_STEP_PILOT, cockpit_device_id = devices.ARC182, value_pressed = 1.0, value_up = 0, name = _('VHF/UHF ARC-182 Volume Pilot Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_VHF_VOL_STEP_PILOT, cockpit_device_id = devices.ARC182, value_pressed = -1.0, value_up = 0, name = _('VHF/UHF ARC-182 Volume Pilot Dec'), category = _('Radio')},
{pressed = device_commands.RADIO_VHF_Remote_DISP_BRT_STEP_Pilot, cockpit_device_id = devices.ARC182, value_pressed = 1.0, value_up = 0, name = _('VHF/UHF ARC-182 Remote BRT Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_VHF_Remote_DISP_BRT_STEP_Pilot, cockpit_device_id = devices.ARC182, value_pressed = -1.0, value_up = 0, name = _('VHF/UHF ARC-182 Remote BRT Dec'), category = _('Radio')},
{down = device_commands.RADIO_VHF_Remote_DISP_TEST_Pilot, up = device_commands.RADIO_VHF_Remote_DISP_TEST_Pilot, cockpit_device_id = devices.ARC182, value_down = 1.0, value_up = 0,name = _('VHF/UHF ARC-182 Remote TEST'), category = _('Radio')},

-- ICS
{pressed = device_commands.RADIO_ICS_Vol_Step_Pilot, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('ICS Volume Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_ICS_Vol_Step_Pilot, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('ICS Volume Dec'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Ampl_Pilot, cockpit_device_id = devices.ICS, value_down = 0, name = _('ICS Amplifier B/U'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Ampl_Pilot, cockpit_device_id = devices.ICS, value_down = 0.5, name = _('ICS Amplifier NORM'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Ampl_Pilot, cockpit_device_id = devices.ICS, value_down = 1, name = _('ICS Amplifier EMER'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Func_Pilot, cockpit_device_id = devices.ICS, value_down = -1, name = _('ICS Function COLD MIC'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Func_Pilot, cockpit_device_id = devices.ICS, value_down = 0, name = _('ICS Function HOT MIC'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Func_Pilot, cockpit_device_id = devices.ICS, value_down = 1, name = _('ICS Function RADIO OVERRIDE'), category = _('Radio')},

-- TONE
--{pressed = device_commands.RADIO_ICS_Vol_Step_ALR45, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('ALR-45 Volume Inc'), category = _('Radio')},
--{pressed = device_commands.RADIO_ICS_Vol_Step_ALR45, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('ALR-45 Volume Dec'), category = _('Radio')},
--{pressed = device_commands.RADIO_ICS_Vol_Step_ALR50, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('ALR-50 Volume Inc'), category = _('Radio')},
--{pressed = device_commands.RADIO_ICS_Vol_Step_ALR50, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('ALR-50 Volume Dec'), category = _('Radio')},
{pressed = device_commands.RADIO_ICS_Vol_Step_ALR67_Pilot, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('ALR-67 Volume Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_ICS_Vol_Step_ALR67_Pilot, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('ALR-67 Volume Dec'), category = _('Radio')},
{pressed = device_commands.RADIO_ICS_Vol_Step_Sidewinder, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('Sidewinder Volume Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_ICS_Vol_Step_Sidewinder, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('Sidewinder Volume Dec'), category = _('Radio')},

-- TACAN
{down = device_commands.TACAN_Knob_Func_Pilot, cockpit_device_id = devices.TACAN, value_down = 0.0/4.0, name = _('TACAN Function OFF'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_Pilot, cockpit_device_id = devices.TACAN, value_down = 1.0/4.0, name = _('TACAN Function REC'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_Pilot, cockpit_device_id = devices.TACAN, value_down = 2.0/4.0, name = _('TACAN Function T/R'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_Pilot, cockpit_device_id = devices.TACAN, value_down = 3.0/4.0, name = _('TACAN Function A/A'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_Pilot, cockpit_device_id = devices.TACAN, value_down = 4.0/4.0, name = _('TACAN Function BCN'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_STEP_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN Function Inc'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_STEP_Pilot, cockpit_device_id = devices.TACAN, value_down = -1, value_up = 0, name = _('TACAN Function Dec'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Tens_Step_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN Channel 10 Inc'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Tens_Step_Pilot, cockpit_device_id = devices.TACAN, value_down = -1, value_up = 0, name = _('TACAN Channel 10 Dec'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Ones_Step_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN Channel 1 Inc'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Ones_Step_Pilot, cockpit_device_id = devices.TACAN, value_down = -1, value_up = 0, name = _('TACAN Channel 1 Dec'), category = _('TACAN')},
{down = device_commands.TACAN_Mode_X_Y_Pilot, cockpit_device_id = devices.TACAN, value_down = 0, name = _('TACAN MODE X'), category = _('TACAN')},
{down = device_commands.TACAN_Mode_X_Y_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, name = _('TACAN MODE Y'), category = _('TACAN')},
{down = device_commands.TACAN_Mode_X_Y_TOGGLE_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN MODE X/Y Toggle'), category = _('TACAN')},
{down = device_commands.TACAN_Btn_BIT_Pilot, up = device_commands.TACAN_Btn_BIT_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN BIT Button'), category = _('TACAN')},
{down = device_commands.TACAN_CMD_Btn_Pilot, up = device_commands.TACAN_CMD_Btn_Pilot, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN CMD Button'), category = _('TACAN')},
{pressed = device_commands.TACAN_Knob_Vol_STEP_Pilot, cockpit_device_id = devices.TACAN, value_pressed = 1.0, value_up = 0, name = _('TACAN Volume Inc'), category = _('TACAN')},
{pressed = device_commands.TACAN_Knob_Vol_STEP_Pilot, cockpit_device_id = devices.TACAN, value_pressed = -1.0, value_up = 0, name = _('TACAN Volume Dec'), category = _('TACAN')},

-- ILS
{down = device_commands.ARA63_Power_Switch, cockpit_device_id = devices.ILS, value_down = 1, name = _('ILS Power ON'), category = _('ILS')},
{down = device_commands.ARA63_Power_Switch, cockpit_device_id = devices.ILS, value_down = 0, name = _('ILS Power OFF'), category = _('ILS')},
{down = device_commands.ARA63_Power_Switch_Toggle, cockpit_device_id = devices.ILS, value_down = 1, value_up = 0, name = _('ILS Power Toggle'), category = _('ILS')},
{down = device_commands.ARA63_BIT_Btn, up = device_commands.ARA63_BIT_Btn, cockpit_device_id = devices.ILS, value_down = 1, value_up = 0, name = _('ILS BIT pushbutton'), category = _('ILS')},
{down = device_commands.ARA63_Chnl_Knob_Step, cockpit_device_id = devices.ILS, value_down = 1, value_up = 0, name = _('ILS Channel Inc'), category = _('ILS')},
{down = device_commands.ARA63_Chnl_Knob_Step, cockpit_device_id = devices.ILS, value_down = -1, value_up = 0, name = _('ILS Channel Dec'), category = _('ILS')},

-- COMPASS / AHRS
{down = device_commands.AHRS_HDG_PushButton, up = device_commands.AHRS_HDG_PushButton, cockpit_device_id = devices.AHRS, value_down = 1, value_up = 0, name = _('Compas HDG pushbutton'), category = _('Compass')},
{down = device_commands.AHRS_ModeSwitch, cockpit_device_id = devices.AHRS, value_down = 1.0, name = _('Compass Mode DG'), category = _('Compass')},
{down = device_commands.AHRS_ModeSwitch, cockpit_device_id = devices.AHRS, value_down = 0.0, name = _('Compass Mode SLAVED'), category = _('Compass')},
{down = device_commands.AHRS_ModeSwitch, cockpit_device_id = devices.AHRS, value_down = -1.0, name = _('Compass Mode COMP'), category = _('Compass')},
{down = device_commands.AHRS_ModeSwitch_STEP, cockpit_device_id = devices.AHRS, value_down = 1, value_up = 0, name = _('Compass Mode Inc'), category = _('Compass')},
{down = device_commands.AHRS_ModeSwitch_STEP, cockpit_device_id = devices.AHRS, value_down = -1, value_up = 0, name = _('Compass Mode Dec'), category = _('Compass')},
{down = device_commands.AHRS_NorthSouth_TOGGLE, cockpit_device_id = devices.AHRS, value_down = 1, value_up = 0, name = _('Compass N-S Hemisphere Switch Toggle'), category = _('Compass')},
{down = device_commands.AHRS_NorthSouth, cockpit_device_id = devices.AHRS, value_down = 1, name = _('Compass N-S Hemisphere Switch: South'), category = _('Compass')},
{down = device_commands.AHRS_NorthSouth, cockpit_device_id = devices.AHRS, value_down = 0, name = _('Compass N-S Hemisphere Switch: North'), category = _('Compass')},
{pressed = device_commands.AHRS_LatCorrection_STEP, cockpit_device_id = devices.AHRS, value_pressed = 1.0, value_up = 0, name = _('Compass LAT Correction Inc'), category = _('Compass')},
{pressed = device_commands.AHRS_LatCorrection_STEP, cockpit_device_id = devices.AHRS, value_pressed = -1.0, value_up = 0, name = _('Compass LAT Correction Dec'), category = _('Compass')},

-- Pilot Instruments
{pressed = device_commands.RADARALT_Knob_step, cockpit_device_id=devices.RADARALTIMETER, value_pressed = 0.03, value_up = 0, name = _('Radar Altimeter Control Knob +'), category = _('Instruments')},
{pressed = device_commands.RADARALT_Knob_step, cockpit_device_id=devices.RADARALTIMETER, value_pressed = -0.03, value_up = 0, name = _('Radar Altimeter Control Knob -'), category = _('Instruments')},
{down = device_commands.RADARALT_Test, up = device_commands.RADARALT_Test, cockpit_device_id=devices.RADARALTIMETER, value_down = 1, value_up = 0, name = _('Radar Altimeter Test'), category = _('Instruments')},
--
{down = device_commands.TID_VideoExportToggle, cockpit_device_id = devices.TID, value_down = 1, name = _('Video Export Toggle'), category = _('Other')},
-- end of key command

-- START OF RIO INPUTS --

--DDD
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_range_5, value_down = 1, up = device_commands.RADAR_DDD_range_5, value_up = 0, name = _('DDD Range 5'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_range_10, value_down = 1, up = device_commands.RADAR_DDD_range_10, value_up = 0, name = _('DDD Range 10'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_range_20, value_down = 1, up = device_commands.RADAR_DDD_range_20, value_up = 0, name = _('DDD Range 20'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_range_50, value_down = 1, up = device_commands.RADAR_DDD_range_50, value_up = 0, name = _('DDD Range 50'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_range_100, value_down = 1, up = device_commands.RADAR_DDD_range_100, value_up = 0, name = _('DDD Range 100'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_range_200, value_down = 1, up = device_commands.RADAR_DDD_range_200, value_up = 0, name = _('DDD Range 200'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_display_radar, value_down = 1, up = device_commands.RADAR_DDD_display_radar, value_up = 0, name = _('DDD display Radar'), category = _('Radar Control Panel')},


{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_Vc_scale, value_down = 1, up = device_commands.RADAR_DDD_Vc_scale, value_up = 0, name = _('Closure Velocity Scale x4 else norm'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_Vc_scale, value_down = -1, up = device_commands.RADAR_DDD_Vc_scale, value_up = 0, name = _('Closure Velocity Scale low else norm'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_Vc_scale, cockpit_device_id=devices.RADAR, value_down = -1, name = _('Closure Velocity Scale low'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_Vc_scale, cockpit_device_id=devices.RADAR, value_down = 0, name = _('Closure Velocity Scale norm'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_Vc_scale, cockpit_device_id=devices.RADAR, value_down = 1, name = _('Closure Velocity Scale x4'), category = _('Radar Control Panel')},

{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_aspect, value_down = 1, up = device_commands.RADAR_DDD_aspect, value_up = 0, name = _('aspect nose else beam'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_aspect, value_down = -1, up = device_commands.RADAR_DDD_aspect, value_up = 0, name = _('aspect tail else beam'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_aspect, cockpit_device_id=devices.RADAR, value_down = -1, name = _('aspect tail'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_aspect, cockpit_device_id=devices.RADAR, value_down = 0, name = _('aspect beam'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_aspect, cockpit_device_id=devices.RADAR, value_down = 1, name = _('aspect nose'), category = _('Radar Control Panel')},

{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_MLC, value_down = 1, up = device_commands.RADAR_DDD_MLC, value_up = 0, name = _('MLC in else auto'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_MLC, value_down = -1, up = device_commands.RADAR_DDD_MLC, value_up = 0, name = _('MLC out else auto'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_MLC, cockpit_device_id=devices.RADAR, value_down = -1, name = _('MLC out'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_MLC, cockpit_device_id=devices.RADAR, value_down = 0, name = _('MLC auto'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_MLC, cockpit_device_id=devices.RADAR, value_down = 1, name = _('MLC in'), category = _('Radar Control Panel')},

{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_tgts, value_down = 1, up = device_commands.RADAR_DDD_tgts, value_up = 0, name = _('TGT size normal else small'), category = _('Radar Control Panel')},
{cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_tgts, value_down = -1, up = device_commands.RADAR_DDD_tgts, value_up = 0, name = _('TGT size large else small'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_tgts, cockpit_device_id=devices.RADAR, value_down = 1, name = _('TGT size normal'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_tgts, cockpit_device_id=devices.RADAR, value_down = 0, name = _('TGT size small'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_DDD_tgts, cockpit_device_id=devices.RADAR, value_down = -1, name = _('TGT size large'), category = _('Radar Control Panel')},

{combos = {{key = 'Q', reformers = {'LShift'}}}, down = device_commands.RADAR_elevation_bars_change, cockpit_device_id=devices.RADAR, value_down = 1, name = _('Radar elevation bars increase'), category = _('Radar Control Panel')},
{combos = {{key = 'Q', reformers = {'LCtrl'}}}, down = device_commands.RADAR_elevation_bars_change, cockpit_device_id=devices.RADAR, value_down = -1, name = _('Radar elevation bars decrease'), category = _('Radar Control Panel')},
{combos = {{key = 'A', reformers = {'LShift'}}}, down = device_commands.RADAR_azimuth_scan_change, cockpit_device_id=devices.RADAR, value_down = 1, name = _('Radar azimuth scan wider'), category = _('Radar Control Panel')},
{combos = {{key = 'A', reformers = {'LCtrl'}}}, down = device_commands.RADAR_azimuth_scan_change, cockpit_device_id=devices.RADAR, value_down = -1, name = _('Radar azimuth scan narrower'), category = _('Radar Control Panel')},
{ combos = {{key = 'W', reformers = {'LAlt'}}}, up = device_commands.RADAR_elevation_updown, down = device_commands.RADAR_elevation_updown, cockpit_device_id=devices.RADAR, value_down = 1, value_up = 0, name = _('Radar elevation up'), category = _('Radar Control Panel')},
{ combos = {{key = 'S', reformers = {'LAlt'}}}, up = device_commands.RADAR_elevation_updown, down = device_commands.RADAR_elevation_updown, cockpit_device_id=devices.RADAR, value_down = -1, value_up = 0, name = _('Radar elevation down'), category = _('Radar Control Panel')},
{ combos = {{key = 'D', reformers = {'LAlt'}}}, up = device_commands.RADAR_azimuth_leftright, down = device_commands.RADAR_azimuth_leftright, cockpit_device_id=devices.RADAR, value_down = 1, value_up = 0, name = _('Radar azimuth right'), category = _('Radar Control Panel')},
{ combos = {{key = 'A', reformers = {'LAlt'}}}, up = device_commands.RADAR_azimuth_leftright, down = device_commands.RADAR_azimuth_leftright, cockpit_device_id=devices.RADAR, value_down = -1, value_up = 0, name = _('Radar azimuth left'), category = _('Radar Control Panel')},
{ combos = {{key = 'W', reformers = {'LAlt','LCtrl'}},{key = 'S', reformers = {'LAlt','LCtrl'}}}, up = device_commands.RADAR_elevation_center, down = device_commands.RADAR_elevation_center, cockpit_device_id=devices.RADAR, value_down = 1, value_up = 0, name = _('Radar elevation re-center'), category = _('Radar Control Panel')},
{ combos = {{key = 'D', reformers = {'LAlt','LCtrl'}},{key = 'A', reformers = {'LAlt','LCtrl'}}}, up = device_commands.RADAR_azimuth_center, down = device_commands.RADAR_azimuth_center, cockpit_device_id=devices.RADAR, value_down = 1, value_up = 0, name = _('Radar azimuth re-center'), category = _('Radar Control Panel')},

{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_PSRCH,   value_down = 1, up = device_commands.RADAR_DDD_WCS_PSRCH,   value_up = 0, name = _('RADAR Pulse Search'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_TWSMAN,  value_down = 1, up = device_commands.RADAR_DDD_WCS_TWSMAN,  value_up = 0, name = _('RADAR Track While Scan manual'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_TWSAUTO, value_down = 1, up = device_commands.RADAR_DDD_WCS_TWSAUTO, value_up = 0, name = _('RADAR Track While Scan auto'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_RWS,     value_down = 1, up = device_commands.RADAR_DDD_WCS_RWS,     value_up = 0, name = _('RADAR Range While Scan'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_PDSRCH,  value_down = 1, up = device_commands.RADAR_DDD_WCS_PDSRCH,  value_up = 0, name = _('RADAR Pulse Doppler Search'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_PSTT,    value_down = 1, up = device_commands.RADAR_DDD_WCS_PSTT,    value_up = 0, name = _('RADAR Pulse Single Target Track'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_WCS_PDSTT,   value_down = 1, up = device_commands.RADAR_DDD_WCS_PDSTT,   value_up = 0, name = _('RADAR Pulse Doppler Single Target Track'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_DDD_display_IFF, value_down = 1, up = device_commands.RADAR_DDD_display_IFF, value_up = 0, name = _('DDD Interrogate Friend or Foe'), category = _('Radar Control Panel')},

{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_VSL_switch, value_down = 1, up = device_commands.RADAR_VSL_switch, value_up = 0, name = _('VSL High'), category = _('Radar Control Panel')},
{ cockpit_device_id=devices.RADAR, down = device_commands.RADAR_VSL_switch, value_down = -1, up = device_commands.RADAR_VSL_switch, value_up = 0, name = _('VSL Low'), category = _('Radar Control Panel')},

{down = device_commands.RADAR_elevation_bars_knob, cockpit_device_id=devices.RADAR, value_down = 0, name = _('1 bar scan'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_elevation_bars_knob, cockpit_device_id=devices.RADAR, value_down = 0.3333, name = _('2 bar scan'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_elevation_bars_knob, cockpit_device_id=devices.RADAR, value_down = 0.6666, name = _('4 bar scan'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_elevation_bars_knob, cockpit_device_id=devices.RADAR, value_down = 0.9999, name = _('8 bar scan'), category = _('Radar Control Panel')},

{down = device_commands.RADAR_azimuth_scan_knob, cockpit_device_id=devices.RADAR, value_down = 0, name = _('+/- 10 degree scan'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_azimuth_scan_knob, cockpit_device_id=devices.RADAR, value_down = 0.3333, name = _('+/- 20 degree scan'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_azimuth_scan_knob, cockpit_device_id=devices.RADAR, value_down = 0.6666, name = _('+/- 40 degree scan'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_azimuth_scan_knob, cockpit_device_id=devices.RADAR, value_down = 0.9999, name = _('+/- 65 degree scan'), category = _('Radar Control Panel')},

{down = device_commands.RADAR_stab_switch,  up = device_commands.RADAR_stab_switch, cockpit_device_id=devices.RADAR, value_down = 1, value_up = -1, name = _('stab in, else out'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_stab_switch,  up = device_commands.RADAR_stab_switch, cockpit_device_id=devices.RADAR, value_down = -1, value_up = 1, name = _('stab out, else in'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_stab_switch, cockpit_device_id=devices.RADAR, value_down = -1, name = _('stab out'), category = _('Radar Control Panel')},
{down = device_commands.RADAR_stab_switch, cockpit_device_id=devices.RADAR, value_down = 1, name = _('stab in'), category = _('Radar Control Panel')},

{down = device_commands.HCU_WCS_enable,  up = device_commands.HCU_WCS_enable, cockpit_device_id=devices.RADAR, value_down = 1, value_up = 0, name = _('WCS XMIT, else Standby'), category = _('Radar Control Panel')},
{down = device_commands.HCU_WCS_enable,  up = device_commands.HCU_WCS_enable, cockpit_device_id=devices.RADAR, value_down = -1, value_up = 0, name = _('WCS Off, else Standby'), category = _('Radar Control Panel')},
{down = device_commands.HCU_WCS_enable, cockpit_device_id=devices.RADAR, value_down = 1, name = _('WCS XMIT'), category = _('Radar Control Panel')},
{down = device_commands.HCU_WCS_enable, cockpit_device_id=devices.RADAR, value_down = 0, name = _('WCS Standby'), category = _('Radar Control Panel')},
{down = device_commands.HCU_WCS_enable, cockpit_device_id=devices.RADAR, value_down = -1, name = _('WCS Off'), category = _('Radar Control Panel')},

-- TCS
{cockpit_device_id=devices.TCS, down = device_commands.TCS_FOV_button, value_down = -1, up = device_commands.TCS_FOV_button, value_up = 1, name = _('FOV narrow, else wide'), category = _('TCS Control Panel')},
{cockpit_device_id=devices.TCS, down = device_commands.TCS_FOV_button, value_down = 1, up = device_commands.TCS_FOV_button, value_up = -1, name = _('FOV wide, else narrow'), category = _('TCS Control Panel')},
{down = device_commands.TCS_FOV_button, cockpit_device_id=devices.TCS, value_down = 1, name = _('TCS FOV wide'), category = _('TCS Control Panel')},
{down = device_commands.TCS_FOV_button, cockpit_device_id=devices.TCS, value_down = -1, name = _('TCS FOV narrow'), category = _('TCS Control Panel')},

{cockpit_device_id=devices.TCS, down = device_commands.TCS_ACQ_switch, value_down = -1, up = device_commands.TCS_ACQ_switch, value_up = 0, name = _('ACQ Auto, else Man '), category = _('TCS Control Panel')},
{cockpit_device_id=devices.TCS, down = device_commands.TCS_ACQ_switch, value_down = 1, up = device_commands.TCS_ACQ_switch, value_up = 0, name = _('ACQ Auto Search, else man '), category = _('TCS Control Panel')},
{down = device_commands.TCS_ACQ_switch, cockpit_device_id=devices.TCS, value_down = -1, name = _('TCS ACQ Auto'), category = _('TCS Control Panel')},
{down = device_commands.TCS_ACQ_switch, cockpit_device_id=devices.TCS, value_down = 0, name = _('TCS ACQ MAN'), category = _('TCS Control Panel')},
{down = device_commands.TCS_ACQ_switch, cockpit_device_id=devices.TCS, value_down = 1, name = _('TCS ACQ Auto Search'), category = _('TCS Control Panel')},

{cockpit_device_id=devices.TCS, down = device_commands.TCS_Slave_switch, value_down = -1, up = device_commands.TCS_Slave_switch, value_up = 0, name = _('TCS slaved, else independent '), category = _('TCS Control Panel')},
{cockpit_device_id=devices.TCS, down = device_commands.TCS_Slave_switch, value_down = 1, up = device_commands.TCS_Slave_switch, value_up = 0, name = _('Radar slaved, else independent '), category = _('TCS Control Panel')},
{down = device_commands.TCS_Slave_switch, cockpit_device_id=devices.TCS, value_down = -1, name = _('Slave TCS'), category = _('TCS Control Panel')},
{down = device_commands.TCS_Slave_switch, cockpit_device_id=devices.TCS, value_down = 0, name = _('TCS/Radar independent'), category = _('TCS Control Panel')},
{down = device_commands.TCS_Slave_switch, cockpit_device_id=devices.TCS, value_down = 1, name = _('Slave Radar'), category = _('TCS Control Panel')},
{combos = {{key = 'O'}}, down = device_commands.TCS_toggle_FOV, cockpit_device_id=devices.TCS, value_down = 1, name = _('Toggle TCS FOV'), category = _('TCS Control Panel')},
{cockpit_device_id=devices.TCS, down = device_commands.HCU_TVIR_enable, value_down = 1, up = device_commands.HCU_TVIR_enable, value_up = 0, name = _('TCS On, else standby'), category = _('TCS Control Panel')},
{cockpit_device_id=devices.TCS, down = device_commands.HCU_TVIR_enable, value_down = -1, up = device_commands.HCU_TVIR_enable, value_up = 0, name = _('TCS Off, else standby'), category = _('TCS Control Panel')},
{down = device_commands.HCU_TVIR_enable, cockpit_device_id=devices.TCS, value_down = 1, name = _('TCS On'), category = _('TCS Control Panel')},
{down = device_commands.HCU_TVIR_enable, cockpit_device_id=devices.TCS, value_down = 0, name = _('TCS Standby'), category = _('TCS Control Panel')},
{down = device_commands.HCU_TVIR_enable, cockpit_device_id=devices.TCS, value_down = -1, name = _('TCS Off'), category = _('TCS Control Panel')},
{down = device_commands.TCS_Trim_az_adjust, cockpit_device_id=devices.TCS, value_down = 1, name = _('TCS azimuth trim inc'), category = _('TCS Control Panel')},
{down = device_commands.TCS_Trim_az_adjust, cockpit_device_id=devices.TCS, value_down = -1, name = _('TCS azimuth trim dec'), category = _('TCS Control Panel')},
{down = device_commands.TCS_Trim_el_adjust, cockpit_device_id=devices.TCS, value_down = 1, name = _('TCS elevation trim inc'), category = _('TCS Control Panel')},
{down = device_commands.TCS_Trim_el_adjust, cockpit_device_id=devices.TCS, value_down = -1, name = _('TCS elevation trim dec'), category = _('TCS Control Panel')},

--************************************* LANTIRN  ******************************************************************
{combos = {{key = 'P'}}, down = device_commands.LANTIRN_TCS_Select_Toggle, up = device_commands.LANTIRN_TCS_Select_Toggle, cockpit_device_id=devices.TID, value_down = 1, value_up = 0, name = _('Toggle LANTIRN / TCS Select'), category = _('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_XAxisKey, up=device_commands.LANTIRN_XAxisKey, value_down=1.0,	value_up=0.0, name=_('LANTIRN Slew Right'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_XAxisKey, up=device_commands.LANTIRN_XAxisKey, value_down=-1.0,	value_up=0.0, name=_('LANTIRN Slew Left'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_YAxisKey, up=device_commands.LANTIRN_YAxisKey, value_down=1.0,	value_up=0.0, name=_('LANTIRN Slew Up'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_YAxisKey, up=device_commands.LANTIRN_YAxisKey, value_down=-1.0,	value_up=0.0, name=_('LANTIRN Slew Down'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_TriggerHalf, up=device_commands.LANTIRN_TriggerHalf, value_down=1.0,	value_up=0.0, name=_('LANTIRN Trigger Half Action'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_TriggerFull, up=device_commands.LANTIRN_TriggerFull, value_down=1.0,	value_up=0.0, name=_('LANTIRN Trigger Full Action'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_LaserLatched, value_down=1.0,	value_up=0.0, name=_('LANTIRN Laser Latched'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_Undesignate, value_down=1.0,	value_up=0.0, name=_('LANTIRN Undesignate'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_ToggleFOV, value_down=1.0, value_up = 0.0, name=_('LANTIRN Toggle FOV'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_PointTrack, up=device_commands.LANTIRN_PointTrack, value_down=1.0,	value_up=0.0, name=_('LANTIRN Point Track'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_AreaTrack, up=device_commands.LANTIRN_AreaTrack, value_down=1.0,	value_up=0.0, name=_('LANTIRN Area Track'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_QHUD_QADL, up=device_commands.LANTIRN_QHUD_QADL,value_down=1.0,	value_up=0.0, name=_('LANTIRN S4 HAT Up (QADL/QHUD/Code +/Gain+)'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_QDES, up=device_commands.LANTIRN_QDES, value_down=1.0,	value_up=0.0, name=_('LANTIRN S4 HAT Right (QDES/Digit Right/Level+)'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_QSNO, up=device_commands.LANTIRN_QSNO, value_down=1.0,	value_up=0.0, name=_('LANTIRN S4 HAT Down (QSNO/Code -/Gain-)'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_QHATLeft, up=device_commands.LANTIRN_QHATLeft, value_down=1.0,	value_up=0.0, name=_('LANTIRN S4 HAT Left (Digit Left/Level-)'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_GPSZero, up=device_commands.LANTIRN_GPSZero, value_down=1.0,	value_up=0.0, name=_('LANTIRN S4 HAT Press (Declutter/Lase Auto-Man/MGC)'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_QWP_Minus, value_down=1.0, name=_('LANTIRN QWP-'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_QWP_Plus, value_down=1.0, name=_('LANTIRN QWP+'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_Laser_ARM_Toggle, value_down=1.0, name=_('LANTIRN Laser Arm Toggle'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_Laser_ARM, value_down=1.0,name=_('LANTIRN Laser Arm ARM'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_Laser_ARM, value_down=0.0, name=_('LANTIRN Laser Arm SAFE'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_ToggleWHOTBHOT, up=device_commands.LANTIRN_ToggleWHOTBHOT, value_down=1.0,	value_up=0.0, name=_('LANTIRN Toggle WHOT / BHOT'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_S1Slider, up=device_commands.LANTIRN_S1Slider, value_down=1.0, value_up = 0, name=_('LANTIRN Slider AGC/MGC'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_S1Slider, up=device_commands.LANTIRN_S1Slider, value_down=-1.0, value_up = 0, name=_('LANTIRN Slider Laser/Focus'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_MasterMode, value_down=0.0,	name=_('LANTIRN Mode NAV - A/A '), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_MasterMode, value_down=1.0,	name=_('LANTIRN Mode A/G'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_MasterModeToggle, value_down=1.0,	name=_('LANTIRN Mode Toggle'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_PowerMode, value_down=0.0,	name=_('LANTIRN Power OFF'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_PowerMode, value_down=0.5,	name=_('LANTIRN Power IMU'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_PowerMode, value_down=1.0,	name=_('LANTIRN Power POD'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_PowerMode_Toggle, value_down=1.0, value_up=0.0, name=_('LANTIRN Power Toggle'), category=_('LANTIRN Control Panel')},
{	cockpit_device_id=devices.LANTIRN, down=device_commands.LANTIRN_OPER_STBY_Toggle, value_down=1.0, value_up=0.0, name=_('LANTIRN OPER / STBY (Unstow)'), category=_('LANTIRN Control Panel')},


{combos = {{key = 'Up'}}, down = device_commands.HCU_key_updown, up = device_commands.HCU_key_updown, value_down = 1, value_up = 0, cockpit_device_id=devices.HCU, name = _('HCU forward'), category = _('Hand Control Unit')},
{combos = {{key = 'Down'}}, down = device_commands.HCU_key_updown, up = device_commands.HCU_key_updown, value_down = -1, value_up = 0, cockpit_device_id=devices.HCU, name = _('HCU backward'), category = _('Hand Control Unit')},
{combos = {{key = 'Left'}}, down = device_commands.HCU_key_leftright, up = device_commands.HCU_key_leftright, value_down = -1, value_up = 0, cockpit_device_id=devices.HCU, name = _('HCU Left'), category = _('Hand Control Unit')},
{combos = {{key = 'Right'}}, down = device_commands.HCU_key_leftright, up = device_commands.HCU_key_leftright, value_down = 1, value_up = 0, cockpit_device_id=devices.HCU, name = _('HCU Right'), category = _('Hand Control Unit')},
{combos = {{key = 'End'}}, down = device_commands.HCU_key_center, value_down = 1, cockpit_device_id=devices.HCU, name = _('HCU Center'), category = _('Hand Control Unit')},
{combos = {{key = 'Home'}}, down = device_commands.HCU_halfaction, up = device_commands.HCU_halfaction, value_down = 1, value_up = 0, cockpit_device_id=devices.HCU, name = _('HCU half-action'), category = _('Hand Control Unit')},
{combos = {{key = 'PageUp'}}, down = device_commands.HCU_fullaction, up = device_commands.HCU_fullaction, value_down = 1, value_up = 0, cockpit_device_id=devices.HCU, name = _('HCU full-action'), category = _('Hand Control Unit')},
{ up=device_commands.HCU_offset, down=device_commands.HCU_offset, cockpit_device_id=devices.HCU, value_up=0.0, value_down=1.0, 	name=_('HCU offset'),	 category=_('Hand Control Unit')},
{ up=device_commands.HCU_MRL, down=device_commands.HCU_MRL, cockpit_device_id=devices.HCU, value_up=0.0, value_down=1.0, 	name=_('HCU MRL'),	 category=_('Hand Control Unit')},

--************** Computer Address Panel ******************8
{down = device_commands.CAP_BRG_0, up = device_commands.CAP_BRG_0, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 0/Bearing'), category = _('Computer Address Panel')},
{down = device_commands.CAP_LAT_1, up = device_commands.CAP_LAT_1, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 1/Latitude'), category = _('Computer Address Panel')},
{down = device_commands.CAP_NBR_2, up = device_commands.CAP_NBR_2, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 2/Number'), category = _('Computer Address Panel')},
{down = device_commands.CAP_SPD_3, up = device_commands.CAP_SPD_3, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 3/Speed'), category = _('Computer Address Panel')},
{down = device_commands.CAP_ALT_4, up = device_commands.CAP_ALT_4, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 4/Altitude'), category = _('Computer Address Panel')},
{down = device_commands.CAP_RNG_5, up = device_commands.CAP_RNG_5, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 5/Range'), category = _('Computer Address Panel')},
{down = device_commands.CAP_LONG_6,up = device_commands.CAP_LONG_6, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 6/Longitude'), category = _('Computer Address Panel')},
{down = device_commands.CAP_7,     up = device_commands.CAP_7, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 7'), category = _('Computer Address Panel')},
{down = device_commands.CAP_HDG_8, up = device_commands.CAP_HDG_8, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 8/Heading'), category = _('Computer Address Panel')},
{down = device_commands.CAP_9,     up = device_commands.CAP_9, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP 9'), category = _('Computer Address Panel')},

{down = device_commands.CAP_enter,     up = device_commands.CAP_enter, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP Enter'), category = _('Computer Address Panel')},
{down = device_commands.CAP_clear,     up = device_commands.CAP_clear, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP Clear'), category = _('Computer Address Panel')},
{down = device_commands.CAP_NE,     up = device_commands.CAP_NE, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP N/E/+'), category = _('Computer Address Panel')},
{down = device_commands.CAP_SW,     up = device_commands.CAP_SW, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP S/W/-'), category = _('Computer Address Panel')},

{down = device_commands.CAP_button1, up = device_commands.CAP_button1, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 1'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button2, up = device_commands.CAP_button2, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 2'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button3, up = device_commands.CAP_button3, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 3'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button4, up = device_commands.CAP_button4, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 4'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button5, up = device_commands.CAP_button5, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 5'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button6, up = device_commands.CAP_button6, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 6'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button7, up = device_commands.CAP_button7, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 7'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button8, up = device_commands.CAP_button8, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 8'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button9, up = device_commands.CAP_button9, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 9'), category = _('Computer Address Panel')},
{down = device_commands.CAP_button10, up = device_commands.CAP_button10, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP button 10'), category = _('Computer Address Panel')},

{down = device_commands.CAP_program_restart, up = device_commands.CAP_program_restart, value_down = 1, value_up = 0, cockpit_device_id=devices.CAP, name = _('CAP program restart'), category = _('Computer Address Panel')},

{down = device_commands.CAP_category, cockpit_device_id=devices.CAP, value_down = 0, name=_('CAP category BIT'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category, cockpit_device_id=devices.CAP, value_down = 0.2, name=_('CAP category SPL'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category, cockpit_device_id=devices.CAP, value_down = 0.4, name=_('CAP category NAV'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category, cockpit_device_id=devices.CAP, value_down = 0.6, name=_('CAP category TAC'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category, cockpit_device_id=devices.CAP, value_down = 0.8, name=_('CAP category D/L'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category, cockpit_device_id=devices.CAP, value_down = 1.0, name=_('CAP category TGT'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category_cw, cockpit_device_id=devices.CAP, value_down = 1.0, name=_('CAP category turn CW'), category=_('Computer Address Panel')},
{down = device_commands.CAP_category_ccw, cockpit_device_id=devices.CAP, value_down = 1.0, name=_('CAP category turn CCW'), category=_('Computer Address Panel')},

{ up=device_commands.HCU_IR_TV, down=device_commands.HCU_IR_TV, cockpit_device_id=devices.HCU, value_up=0.0, value_down=1.0, 	name=_('HCU TCS mode'),	 category=_('Hand Control Unit')},
{ up=device_commands.HCU_RDR, down=device_commands.HCU_RDR, cockpit_device_id=devices.HCU, value_up=0.0, value_down=1.0, 	name=_('HCU radar mode'),	 category=_('Hand Control Unit')},
{ up=device_commands.HCU_DDD_cursor, down=device_commands.HCU_DDD_cursor, cockpit_device_id=devices.HCU, value_up=0.0, value_down=1.0, 	name=_('HCU DDD mode'),	 category=_('Hand Control Unit')},
{ up=device_commands.HCU_TID_cursor, down=device_commands.HCU_TID_cursor, cockpit_device_id=devices.HCU, value_up=0.0, value_down=1.0, 	name=_('HCU TID mode'),	 category=_('Hand Control Unit')},
{ up = device_commands.HCU_thumb, down = device_commands.HCU_thumb, cockpit_device_id=devices.RADAR, value_up = 0, value_down = 1, name = _('HCU thumb up'), category = _('Hand Control Unit')},
{ up = device_commands.HCU_thumb_center, down = device_commands.HCU_thumb_center, cockpit_device_id=devices.RADAR, value_up = 0, value_down = 1, name = _('HCU thumb re-center'), category = _('Hand Control Unit')},
{ up = device_commands.HCU_thumb, down = device_commands.HCU_thumb, cockpit_device_id=devices.RADAR, value_up = 0, value_down = -1, name = _('HCU thumb down'), category = _('Hand Control Unit')},

-- TID
--TID
{down = device_commands.TID_mode_knob, cockpit_device_id=devices.TID, value_down = 0, name = _('TID Mode: GND STAB'), category = _('TID')},
{down = device_commands.TID_mode_knob, cockpit_device_id=devices.TID, value_down = 0.3333, name = _('TID Mode: AC STAB'), category = _('TID')},
{down = device_commands.TID_mode_knob, cockpit_device_id=devices.TID, value_down = 0.6666, name = _('TID Mode: ATTK'), category = _('TID')},
{down = device_commands.TID_mode_knob, cockpit_device_id=devices.TID, value_down = 1.0, name = _('TID Mode: TV'), category = _('TID')},
{down = device_commands.TID_mode_knob_step, cockpit_device_id=devices.TID, value_down = 1.0, name = _('TID Mode CW'), category = _('TID')},
{down = device_commands.TID_mode_knob_step, cockpit_device_id=devices.TID, value_down = -1.0, name = _('TID Mode CCW'), category = _('TID')},

{down = device_commands.TID_range_knob, cockpit_device_id=devices.TID, value_down = -1.0, name = _('TID range: 25'), category = _('TID')},
{down = device_commands.TID_range_knob, cockpit_device_id=devices.TID, value_down = -0.5, name = _('TID range: 50'), category = _('TID')},
{down = device_commands.TID_range_knob, cockpit_device_id=devices.TID, value_down = 0.0, name = _('TID range: 100'), category = _('TID')},
{down = device_commands.TID_range_knob, cockpit_device_id=devices.TID, value_down = 0.5, name = _('TID range: 200'), category = _('TID')},
{down = device_commands.TID_range_knob, cockpit_device_id=devices.TID, value_down = 1.0, name = _('TID range: 400'), category = _('TID')},
{down = device_commands.TID_range_knob_step, cockpit_device_id=devices.TID, value_down = 1.0, name = _('TID range +'), category = _('TID')},
{down = device_commands.TID_range_knob_step, cockpit_device_id=devices.TID, value_down = -1.0, name = _('TID range -'), category = _('TID')},

{cockpit_device_id=devices.TID, down = device_commands.TID_NON_ATTK, value_down = 1, up = device_commands.TID_NON_ATTK, value_up = 0, name = _('TID Symbology: Non Attack'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_DATA_LINK, value_down = 1, up = device_commands.TID_DATA_LINK, value_up = 0, name = _('TID Symbology: Data Link'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_JAM_STROBE, value_down = 1, up = device_commands.TID_JAM_STROBE, value_up = 0, name = _('TID Symbology: Jam Strobe'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_SYM_ELEM, value_down = 1, up = device_commands.TID_SYM_ELEM, value_up = 0, name = _('TID Symbology: Sym Elem'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_ALT_NUM, value_down = 1, up = device_commands.TID_ALT_NUM, value_up = 0, name = _('TID Symbology: Alt Num'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_RID_DSBL, value_down = 1, up = device_commands.TID_RID_DSBL, value_up = 0, name = _('TID Symbology: RID DSBL'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_LAUNCH_ZONE, value_down = 1, up = device_commands.TID_LAUNCH_ZONE, value_up = 0, name = _('TID Symbology: Launch Zone'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_VEL_VECTOR, value_down = 1, up = device_commands.TID_VEL_VECTOR, value_up = 0, name = _('TID Symbology: Vel Vector'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_CLSN, value_down = 1, up = device_commands.TID_CLSN, value_up = 0, name = _('TID CLSN'), category = _('TID')},
{cockpit_device_id=devices.TID, down = device_commands.TID_trackhold, value_down = 1, up = device_commands.TID_trackhold, value_up = 0, name = _('TID Trackhold'), category = _('TID')},

{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 0, name = _('NAV Mode: Off'), category = _('TID')},
{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 0.1666667, name = _('NAV Mode: GND ALIGN'), category = _('TID')},
{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 0.3333334, name = _('NAV Mode: CVA ALIGN'), category = _('TID')},
{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 0.5000001, name = _('NAV Mode: CAT ALIGN'), category = _('TID')},
{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 0.6666668, name = _('NAV Mode: INS'), category = _('TID')},
{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 0.8333335, name = _('NAV Mode: AHRS'), category = _('TID')},
{down = device_commands.TID_nav_mode, cockpit_device_id=devices.INS, value_down = 1.0, name = _('NAV Mode: IMU'), category = _('TID')},

{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0, name = _('TID Destination: 1'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0.142857, name = _('TID Destination: 2'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0.285714, name = _('TID Destination: 3'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0.428571, name = _('TID Destination: FP'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0.571428, name = _('TID Destination: IP'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0.714285, name = _('TID Destination: ST'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 0.857142, name = _('TID Destination: HB'), category = _('TID')},
{down = device_commands.TID_dest_mode, cockpit_device_id=devices.NAV_INTERFACE, value_down = 1.0, name = _('TID Destination: MAN'), category = _('TID')},

--*************** Datalink *****************************
{ down = device_commands.DATALINK_Mode_Down, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Mode Down'), category = _('Datalink')},
{ down = device_commands.DATALINK_Mode_Up, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Mode Up'), category = _('Datalink')},
{ down = device_commands.DATALINK_FreqHi_Down, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Frequency 10MHz down'), category = _('Datalink')},
{ down = device_commands.DATALINK_FreqHi_Up, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Frequency 10MHz up'), category = _('Datalink')},
{ down = device_commands.DATALINK_FreqMid_Down, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Frequency 1MHz down'), category = _('Datalink')},
{ down = device_commands.DATALINK_FreqMid_Up, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Frequency 1MHz up'), category = _('Datalink')},
{ down = device_commands.DATALINK_FreqLo_Down, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Frequency 100kHz down'), category = _('Datalink')},
{ down = device_commands.DATALINK_FreqLo_Up, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('Datalink Frequency 100kHz up'), category = _('Datalink')},
{ down = device_commands.DATALINK_tac_cains, cockpit_device_id=devices.DATALINK, value_down = 1, name = _('CAINS/WPT'), category = _('Datalink')},

--*************** CMS *****************************
{down = device_commands.CMDS_Master_Mode_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, name = _('AN/ALE-39 Power/Mode AUTO'), category = _('Countermeasures')},
{down = device_commands.CMDS_Master_Mode_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 Power/Mode MAN'), category = _('Countermeasures')},
{down = device_commands.CMDS_Master_Mode_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, name = _('AN/ALE-39 Power/Mode OFF'), category = _('Countermeasures')},
{down = device_commands.CMDS_Master_Mode_SW_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Power/Mode Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Master_Mode_SW_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Power/Mode Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Oper_SW, up = device_commands.CMDS_Chaff_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Chaff PRGM'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 Chaff STBY'), category = _('Countermeasures')},
{combos = {{key = 'Insert'}}, down = device_commands.CMDS_Chaff_Oper_SW, up = device_commands.CMDS_Chaff_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Chaff SGL'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Oper_SW, up = device_commands.CMDS_Flare_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Flare PRGM'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 Flare STBY'), category = _('Countermeasures')},
{combos = {{key = 'Delete'}}, down = device_commands.CMDS_Flare_Oper_SW, up = device_commands.CMDS_Flare_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Flare SGL'), category = _('Countermeasures')},
{down = device_commands.CMDS_Jammer_Oper_SW, up = device_commands.CMDS_Jammer_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Jammer PRGM'), category = _('Countermeasures')},
{down = device_commands.CMDS_Jammer_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 Jammer STBY'), category = _('Countermeasures')},
{down = device_commands.CMDS_Jammer_Oper_SW, up = device_commands.CMDS_Jammer_Oper_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Jammer SGL'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Salvo_SW, up = device_commands.CMDS_Flare_Salvo_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Flare Salvo ON'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Mode_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, name = _('AN/ALE-39 Flare Mode MULT'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Mode_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 Flare Mode NORM'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Mode_SW, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, name = _('AN/ALE-39 Flare Mode PILOT'), category = _('Countermeasures')},
{cockpit_device_id=devices.COUNTERMEASURES, down = device_commands.CMDS_Flare_Mode_SW, value_down = 1, up = device_commands.CMDS_Flare_Mode_SW, value_up = 0, name = _('AN/ALE-39 Flare Mode Mult, else Norm'), category = _('Countermeasures')},
{cockpit_device_id=devices.COUNTERMEASURES, down = device_commands.CMDS_Flare_Mode_SW, value_down = -1, up = device_commands.CMDS_Flare_Mode_SW, value_up = 0, name = _('AN/ALE-39 Flare Mode Pilot, else Norm '), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Mode_SW_Step, up = device_commands.CMDS_Flare_Mode_SW_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Flare Mode Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Mode_SW_Step, up = device_commands.CMDS_Flare_Mode_SW_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Flare Mode Dec'), category = _('Countermeasures')},
{pressed = device_commands.CMDS_Chaff_Counter_Control_Step, cockpit_device_id = devices.COUNTERMEASURES, value_pressed = 1, value_up = 0, name = _('AN/ALE-39 Chaff Counter Inc'), category = _('Countermeasures')},
{pressed = device_commands.CMDS_Chaff_Counter_Control_Step, cockpit_device_id = devices.COUNTERMEASURES, value_pressed = -1, value_up = 0, name = _('AN/ALE-39 Chaff Counter Dec'), category = _('Countermeasures')},
{pressed = device_commands.CMDS_Flare_Counter_Control_Step, cockpit_device_id = devices.COUNTERMEASURES, value_pressed = 1, value_up = 0, name = _('AN/ALE-39 Flare Counter Inc'), category = _('Countermeasures')},
{pressed = device_commands.CMDS_Flare_Counter_Control_Step, cockpit_device_id = devices.COUNTERMEASURES, value_pressed = -1, value_up = 0, name = _('AN/ALE-39 Flare Counter Dec'), category = _('Countermeasures')},
{pressed = device_commands.CMDS_Jammer_Counter_Control_Step, cockpit_device_id = devices.COUNTERMEASURES, value_pressed = 1, value_up = 0, name = _('AN/ALE-39 Jammer Counter Inc'), category = _('Countermeasures')},
{pressed = device_commands.CMDS_Jammer_Counter_Control_Step, cockpit_device_id = devices.COUNTERMEASURES, value_pressed = -1, value_up = 0, name = _('AN/ALE-39 Jammer Counter Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_L10_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 L10 Load Type Chaff'), category = _('Countermeasures')},
{down = device_commands.CMDS_L10_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0.5, name = _('AN/ALE-39 L10 Load Type Flare'), category = _('Countermeasures')},
{down = device_commands.CMDS_L10_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1.0, name = _('AN/ALE-39 L10 Load Type Jammer'), category = _('Countermeasures')},
{down = device_commands.CMDS_L10_Wheel_Step, up = device_commands.CMDS_L10_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 L10 Load Type Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_L10_Wheel_Step, up = device_commands.CMDS_L10_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 L10 Load Type Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_L20_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 L20 Load Type Chaff'), category = _('Countermeasures')},
{down = device_commands.CMDS_L20_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0.5, name = _('AN/ALE-39 L20 Load Type Flare'), category = _('Countermeasures')},
{down = device_commands.CMDS_L20_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1.0, name = _('AN/ALE-39 L20 Load Type Jammer'), category = _('Countermeasures')},
{down = device_commands.CMDS_L20_Wheel_Step, up = device_commands.CMDS_L20_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 L20 Load Type Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_L20_Wheel_Step, up = device_commands.CMDS_L20_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 L20 Load Type Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_R10_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 R10 Load Type Chaff'), category = _('Countermeasures')},
{down = device_commands.CMDS_R10_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0.5, name = _('AN/ALE-39 R10 Load Type Flare'), category = _('Countermeasures')},
{down = device_commands.CMDS_R10_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1.0, name = _('AN/ALE-39 R10 Load Type Jammer'), category = _('Countermeasures')},
{down = device_commands.CMDS_R10_Wheel_Step, up = device_commands.CMDS_R10_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 R10 Load Type Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_R10_Wheel_Step, up = device_commands.CMDS_R10_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 R10 Load Type Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_R20_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0, name = _('AN/ALE-39 R20 Load Type Chaff'), category = _('Countermeasures')},
{down = device_commands.CMDS_R20_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 0.5, name = _('AN/ALE-39 R20 Load Type Flare'), category = _('Countermeasures')},
{down = device_commands.CMDS_R20_Wheel, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1.0, name = _('AN/ALE-39 R20 Load Type Jammer'), category = _('Countermeasures')},
{down = device_commands.CMDS_R20_Wheel_Step, up = device_commands.CMDS_R20_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 R20 Load Type Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_R20_Wheel_Step, up = device_commands.CMDS_R20_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 R20 Load Type Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Intv_1_Step, up = device_commands.CMDS_JAMR_Intv_1_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Jammer Interval Units Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Intv_1_Step, up = device_commands.CMDS_JAMR_Intv_1_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Jammer Interval Units Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Intv_10_Step, up = device_commands.CMDS_JAMR_Intv_10_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Jammer Interval Tens Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Intv_10_Step, up = device_commands.CMDS_JAMR_Intv_10_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Jammer Interval Tens Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Intv_100_Step, up = device_commands.CMDS_JAMR_Intv_100_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Jammer Interval Hundreds Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Intv_100_Step, up = device_commands.CMDS_JAMR_Intv_100_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Jammer Interval Hundreds Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Qty_Step, up = device_commands.CMDS_JAMR_Qty_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Jammer Quantity Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_JAMR_Qty_Step, up = device_commands.CMDS_JAMR_Qty_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Jammer Quantity Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Burst_Qty_Wheel_Step, up = device_commands.CMDS_Chaff_Burst_Qty_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Chaff Burst Quantity Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Burst_Qty_Wheel_Step, up = device_commands.CMDS_Chaff_Burst_Qty_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Chaff Burst Quantity Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Burst_Intv_Wheel_Step, up = device_commands.CMDS_Chaff_Burst_Intv_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Chaff Burst Interval Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Burst_Intv_Wheel_Step, up = device_commands.CMDS_Chaff_Burst_Intv_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Chaff Burst Interval Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Salvo_Qty_Wheel_Step, up = device_commands.CMDS_Chaff_Salvo_Qty_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Chaff Salvo Quantity Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Salvo_Qty_Wheel_Step, up = device_commands.CMDS_Chaff_Salvo_Qty_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Chaff Salvo Quantity Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Salvo_Intv_Wheel_Step, up = device_commands.CMDS_Chaff_Salvo_Intv_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Chaff Salvo Interval Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Chaff_Salvo_Intv_Wheel_Step, up = device_commands.CMDS_Chaff_Salvo_Intv_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Chaff Salvo Interval Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Qty_Wheel_Step, up = device_commands.CMDS_Flare_Qty_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Flare Quantity Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Qty_Wheel_Step, up = device_commands.CMDS_Flare_Qty_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Flare Quantity Dec'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Intv_Wheel_Step, up = device_commands.CMDS_Flare_Intv_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Flare Interval Inc'), category = _('Countermeasures')},
{down = device_commands.CMDS_Flare_Intv_Wheel_Step, up = device_commands.CMDS_Flare_Intv_Wheel_Step, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Flare Interval Dec'), category = _('Countermeasures')},	
{down = device_commands.CMDS_Programmer_Reset, up = device_commands.CMDS_Programmer_Reset, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Programmer Reset'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Left_Grip_Hat_V, up = device_commands.CMDS_RIO_Left_Grip_Hat_V, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Left Data Dispenser Switch Up - Chaff Single'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Left_Grip_Hat_H, up = device_commands.CMDS_RIO_Left_Grip_Hat_H, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Left Data Dispenser Switch Left - Flare Program'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Left_Grip_Hat_V, up = device_commands.CMDS_RIO_Left_Grip_Hat_V, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Left Data Dispenser Switch Down - Chaff Program'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Left_Grip_Hat_H, up = device_commands.CMDS_RIO_Left_Grip_Hat_H, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Left Data Dispenser Switch Right - Jammer Program'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Right_Grip_Hat_V, up = device_commands.CMDS_RIO_Right_Grip_Hat_V, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Right Data Dispenser Switch Up - Chaff Single'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Right_Grip_Hat_H, up = device_commands.CMDS_RIO_Right_Grip_Hat_H, cockpit_device_id = devices.COUNTERMEASURES, value_down = 1, value_up = 0, name = _('AN/ALE-39 Right Data Dispenser Switch Right - Flare Program'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Right_Grip_Hat_V, up = device_commands.CMDS_RIO_Right_Grip_Hat_V, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Right Data Dispenser Switch Down - Chaff Program'), category = _('Countermeasures')},
{down = device_commands.CMDS_RIO_Right_Grip_Hat_H, up = device_commands.CMDS_RIO_Right_Grip_Hat_H, cockpit_device_id = devices.COUNTERMEASURES, value_down = -1, value_up = 0, name = _('AN/ALE-39 Right Data Dispenser Switch Left - Jammer Program'), category = _('Countermeasures')},


--************************************* Iceman AI  ******************************************************************

--Menu
{combos = {{key = 'A'}},		 cockpit_device_id=devices.JESTERAI, up =device_commands.JESTER_ToggleMenu ,down=device_commands.JESTER_ToggleMenu, value_up=-1.0, value_down=1.0,	name=_('Toggle Menu'),	 category=_('Iceman AI')},
{combos = {{key = '1',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command1, value_down=1.0,	name=_('Command 1'),	 category=_('Iceman AI')},
{combos = {{key = '2',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command2, value_down=1.0,	name=_('Command 2'),	 category=_('Iceman AI')},
{combos = {{key = '3',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command3, value_down=1.0,	name=_('Command 3'),	 category=_('Iceman AI')},
{combos = {{key = '4',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command4, value_down=1.0,	name=_('Command 4'),	 category=_('Iceman AI')},
{combos = {{key = '5',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command5, value_down=1.0,	name=_('Command 5'),	 category=_('Iceman AI')},
{combos = {{key = '6',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command6, value_down=1.0,	name=_('Command 6'),	 category=_('Iceman AI')},
{combos = {{key = '7',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command7, value_down=1.0,	name=_('Command 7'),	 category=_('Iceman AI')},
{combos = {{key = '8',reformers={'LCtrl'}}},		 cockpit_device_id=devices.JESTERAI, down=device_commands.JESTER_Command8, value_down=1.0,	name=_('Command 8'),	 category=_('Iceman AI')},




--*************** RWR *****************************
-- ALR-67
{pressed = device_commands.RWR_ALR67_Volume_Step, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('ALR-67 Volume Inc'), category = _('RWR')},
{pressed = device_commands.RWR_ALR67_Volume_Step, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('ALR-67 Volume Dec'), category = _('RWR')},

{down = device_commands.RWR_DISPLAY_MODE, up = device_commands.RWR_DISPLAY_MODE, cockpit_device_id=devices.RWR, value_down = 1, value_up = 0, name = _('RWR Display Mode OFST'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_MODE, up = device_commands.RWR_DISPLAY_MODE, cockpit_device_id=devices.RWR, value_down = -1, value_up = 0, name = _('RWR Display Mode LMT'), category = _('RWR')},
{down = device_commands.RWR_POWER, cockpit_device_id=devices.RWR, value_down = 1, name = _('RWR Power ON'), category = _('RWR')},
{down = device_commands.RWR_POWER, cockpit_device_id=devices.RWR, value_down = 0, name = _('RWR Power OFF'), category = _('RWR')},
{down = device_commands.RWR_POWER_Toggle, cockpit_device_id=devices.RWR, value_down = 1, value_up = 0, name = _('RWR Power Toggle'), category = _('RWR')},
{down = device_commands.RWR_TEST_SWITCH, up = device_commands.RWR_TEST_SWITCH, cockpit_device_id=devices.RWR, value_down = 1, value_up = 0, name = _('RWR Test SPL'), category = _('RWR')},
{down = device_commands.RWR_TEST_SWITCH, up = device_commands.RWR_TEST_SWITCH, cockpit_device_id=devices.RWR, value_down = -1, value_up = 0, name = _('RWR Test BIT'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE, cockpit_device_id=devices.RWR, value_down = 0, name = _('RWR Display Type NORM'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE, cockpit_device_id=devices.RWR, value_down = 0.25, name = _('RWR Display Type AI'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE, cockpit_device_id=devices.RWR, value_down = 0.5, name = _('RWR Display Type AAA'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE, cockpit_device_id=devices.RWR, value_down = 0.75, name = _('RWR Display Type UNK'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE, cockpit_device_id=devices.RWR, value_down = 1, name = _('RWR Display Type FRIEND'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE_Step, cockpit_device_id=devices.RWR, value_down = 1, value_up = 0, name = _('RWR Display Type CW'), category = _('RWR')},
{down = device_commands.RWR_DISPLAY_TYPE_Step, cockpit_device_id=devices.RWR, value_down = -1, value_up = 0, name = _('RWR Display Type CCW'), category = _('RWR')},
{pressed = device_commands.RWR_Brightness_RIO_Step, cockpit_device_id = devices.RWR, value_pressed = 1.0, value_up = 0, name = _('RWR Brightness RIO Inc'), category = _('RWR')},
{pressed = device_commands.RWR_Brightness_RIO_Step, cockpit_device_id = devices.RWR, value_pressed = -1.0, value_up = 0, name = _('RWR Brightness RIO Dec'), category = _('RWR')},
{down = device_commands.RWR_POWER, up = device_commands.RWR_POWER, cockpit_device_id=devices.RWR, value_down = 0, value_up = 1, name = _('RWR Power OFF else ON'), category = _('RWR')},
{down = device_commands.RWR_POWER, up = device_commands.RWR_POWER, cockpit_device_id=devices.RWR, value_down = 1, value_up = 0, name = _('RWR Power ON else OFF'), category = _('RWR')},

--***************************************** INS *************************************************************
{combos = {{key = 'I', reformers = {'LCtrl'}}}, down = device_commands.TID_nav_mode_inc, cockpit_device_id = devices.INS, value_down = 1, name = _('INS Nav Mode CW'), category = _('INS')},
{combos = {{key = 'I', reformers = {'LAlt'}}}, down = device_commands.TID_nav_mode_dec, cockpit_device_id = devices.INS, value_down = -1, name = _('INS Nav Mode CCW'), category = _('INS')},

--***************************************** Radio *************************************************************
{combos = {{key = '\\', reformers = {'RAlt'}}}, down=device_commands.RADIO_ICS_Button_MIC_RIO, up=device_commands.RADIO_ICS_Button_MIC_RIO, cockpit_device_id=devices.ICS, value_down=1.0, value_up=0.0, name=_('Mic Button UHF'), category=_('Radio')},
{combos = {{key = '\\', reformers = {'RCtrl'}}}, down = device_commands.RADIO_ICS_XMTR_SEL_TOGGLE_RIO, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('Mic XMTR SEL Toggle'), category = _('Radio')},
{combos = {{key = '\\', reformers = {'RShift'}}}, down=device_commands.RADIO_ICS_Button_ICS_RIO, up=device_commands.RADIO_ICS_Button_ICS_RIO, cockpit_device_id=devices.ICS, value_down=1.0, value_up=0.0, name=_('Mic Button ICS'), category=_('Radio')},

{down=device_commands.RADIO_ICS_Button_MIC_RIO_Export_Only, up=device_commands.RADIO_ICS_Button_MIC_RIO_Export_Only, cockpit_device_id=devices.ICS, value_down=1.0, value_up=0.0, name=_('Mic Button UHF - SRS or VoIP Only / No Menu'), category=_('Radio')},
{down=device_commands.RADIO_ICS_Button_ICS_RIO_Export_Only, up=device_commands.RADIO_ICS_Button_ICS_RIO_Export_Only, cockpit_device_id=devices.ICS, value_down=1.0, value_up=0.0, name=_('Mic Button ICS - SRS or VoIP Only / No Menu'), category=_('Radio')},

-- ARC-159
{pressed = device_commands.RADIO_UHF_VOL_STEP_RIO, cockpit_device_id = devices.ARC159, value_pressed = 1.0, value_up = 0, name = _('UHF ARC-159 Volume RIO Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_VOL_STEP_RIO, cockpit_device_id = devices.ARC159, value_pressed = -1.0, value_up = 0, name = _('UHF ARC-159 Volume RIO Dec'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_Remote_DISP_BRT_STEP_RIO, cockpit_device_id = devices.ARC159, value_pressed = 1.0, value_up = 0, name = _('UHF ARC-159 Remote BRT Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_UHF_Remote_DISP_BRT_STEP_RIO, cockpit_device_id = devices.ARC159, value_pressed = -1.0, value_up = 0, name = _('UHF ARC-159 Remote BRT Dec'), category = _('Radio')},
{down = device_commands.RADIO_UHF_Remote_DISP_TEST_RIO, up = device_commands.RADIO_UHF_Remote_DISP_TEST_RIO, cockpit_device_id = devices.ARC159, value_down = 1.0, value_up = 0,name = _('UHF ARC-159 Remote TEST'), category = _('Radio')},

-- ARC-182
{pressed = device_commands.RADIO_VHF_VOL_STEP_RIO, cockpit_device_id = devices.ARC182, value_pressed = 1.0, value_up = 0, name = _('VHF/UHF ARC-182 Volume RIO Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_VHF_VOL_STEP_RIO, cockpit_device_id = devices.ARC182, value_pressed = -1.0, value_up = 0, name = _('VHF/UHF ARC-182 Volume RIO Dec'), category = _('Radio')},
{down = device_commands.RADIO_VHF_SQL_TOGGLE_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 Squelch Toggle'), category = _('Radio')},
{down = device_commands.RADIO_VHF_SQL_RIO, cockpit_device_id = devices.ARC182, value_down = 1, name = _('VHF/UHF ARC-182 Squelch SQL'), category = _('Radio')},
{down = device_commands.RADIO_VHF_SQL_RIO, cockpit_device_id = devices.ARC182, value_down = 0, name = _('VHF/UHF ARC-182 Squelch OFF'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_HUNDRED_TEN_RIO, up = device_commands.RADIO_VHF_FREQ_HUNDRED_TEN_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 10 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_HUNDRED_TEN_RIO, up = device_commands.RADIO_VHF_FREQ_HUNDRED_TEN_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 10 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_UNIT_RIO, up = device_commands.RADIO_VHF_FREQ_UNIT_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 1 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_UNIT_RIO, up = device_commands.RADIO_VHF_FREQ_UNIT_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 1 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_TEHTH_RIO, up = device_commands.RADIO_VHF_FREQ_TEHTH_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 0.1 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_TEHTH_RIO, up = device_commands.RADIO_VHF_FREQ_TEHTH_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 0.1 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_HUNDREDTH_RIO, up = device_commands.RADIO_VHF_FREQ_HUNDREDTH_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 0.025 MHz Switch Up'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_HUNDREDTH_RIO, up = device_commands.RADIO_VHF_FREQ_HUNDREDTH_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 0.025 MHz Switch Down'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FM_AM_TOGGLE_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 UHF Modulation Toggle'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FM_AM_RIO, cockpit_device_id = devices.ARC182, value_down = 1, name = _('VHF/UHF ARC-182 UHF Modulation AM'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FM_AM_RIO, cockpit_device_id = devices.ARC182, value_down = 0, name = _('VHF/UHF ARC-182 UHF Modulation FM'), category = _('Radio')},
{pressed = device_commands.RADIO_VHF_BRT_STEP_RIO, cockpit_device_id = devices.ARC182, value_pressed = 1.0, value_up = 0, name = _('VHF/UHF ARC-182 BRT Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_VHF_BRT_STEP_RIO, cockpit_device_id = devices.ARC182, value_pressed = -1.0, value_up = 0, name = _('VHF/UHF ARC-182 BRT Dec'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_RIO, cockpit_device_id = devices.ARC182, value_down = 0, name = _('VHF/UHF ARC-182 MODE OFF'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_RIO, cockpit_device_id = devices.ARC182, value_down = 0.25, name = _('VHF/UHF ARC-182 MODE T/R'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_RIO, cockpit_device_id = devices.ARC182, value_down = 0.5, name = _('VHF/UHF ARC-182 MODE T/R&G'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_RIO, cockpit_device_id = devices.ARC182, value_down = 0.75, name = _('VHF/UHF ARC-182 MODE DF'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_RIO, cockpit_device_id = devices.ARC182, value_down = 1.0, name = _('VHF/UHF ARC-182 MODE TEST'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_STEP_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 MODE Inc'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FUNC_STEP_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 MODE Dec'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_RIO, cockpit_device_id = devices.ARC182, value_down = 0, name = _('VHF/UHF ARC-182 Freq Mode 243'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_RIO, cockpit_device_id = devices.ARC182, value_down = 0.2, name = _('VHF/UHF ARC-182 Freq Mode MAN'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_RIO, cockpit_device_id = devices.ARC182, value_down = 0.4, name = _('VHF/UHF ARC-182 Freq Mode G'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_RIO, cockpit_device_id = devices.ARC182, value_down = 0.6, name = _('VHF/UHF ARC-182 Freq Mode PRESET'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_RIO, cockpit_device_id = devices.ARC182, value_down = 0.8, name = _('VHF/UHF ARC-182 Freq Mode READ'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_RIO, cockpit_device_id = devices.ARC182, value_down = 1.0, name = _('VHF/UHF ARC-182 Freq Mode LOAD'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_STEP_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 Freq Mode Inc'), category = _('Radio')},
{down = device_commands.RADIO_VHF_FREQ_MODE_STEP_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 Freq Mode Dec'), category = _('Radio')},
{down = device_commands.RADIO_VHF_CHAN_STEP_RIO, cockpit_device_id = devices.ARC182, value_down = 1, value_up = 0, name = _('VHF/UHF ARC-182 CHAN SEL Inc'), category = _('Radio')},
{down = device_commands.RADIO_VHF_CHAN_STEP_RIO, cockpit_device_id = devices.ARC182, value_down = -1, value_up = 0, name = _('VHF/UHF ARC-182 CHAN SEL Dec'), category = _('Radio')},

-- ICS

{pressed = device_commands.RADIO_ICS_Vol_Step_RIO, cockpit_device_id = devices.ICS, value_pressed = 1.0, value_up = 0, name = _('ICS Volume Inc'), category = _('Radio')},
{pressed = device_commands.RADIO_ICS_Vol_Step_RIO, cockpit_device_id = devices.ICS, value_pressed = -1.0, value_up = 0, name = _('ICS Volume Dec'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Ampl_RIO, cockpit_device_id = devices.ICS, value_down = 0, name = _('ICS Amplifier B/U'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Ampl_RIO, cockpit_device_id = devices.ICS, value_down = 0.5, name = _('ICS Amplifier NORM'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Ampl_RIO, cockpit_device_id = devices.ICS, value_down = 1, name = _('ICS Amplifier EMER'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Func_RIO, cockpit_device_id = devices.ICS, value_down = -1, name = _('ICS Function COLD MIC'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Func_RIO, cockpit_device_id = devices.ICS, value_down = 0, name = _('ICS Function HOT MIC'), category = _('Radio')},
{down = device_commands.RADIO_ICS_Func_RIO, cockpit_device_id = devices.ICS, value_down = 1, name = _('ICS Function RADIO OVERRIDE'), category = _('Radio')},
{down = device_commands.RADIO_ICS_XMTR_SEL_RIO, cockpit_device_id = devices.ICS, value_down = 1, name = _('XMTR SEL UHF1'), category = _('Radio')},
{down = device_commands.RADIO_ICS_XMTR_SEL_RIO, cockpit_device_id = devices.ICS, value_down = -1, name = _('XMTR SEL UHF2'), category = _('Radio')},
{down = device_commands.RADIO_ICS_XMTR_SEL_RIO, cockpit_device_id = devices.ICS, value_down = 0, name = _('XMTR SEL BOTH'), category = _('Radio')},
{down = device_commands.RADIO_VHF_SQL_TOGGLE_RIO, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('XMTR SEL Toggle'), category = _('Radio')},

-- KY-28
{down = device_commands.RADIO_KY28_POWER_MODE, cockpit_device_id = devices.ICS, value_down = 0, name = _('KY-28 POWER-MODE OFF'), category = _('Radio')},
{down = device_commands.RADIO_KY28_POWER_MODE, cockpit_device_id = devices.ICS, value_down = 0, name = _('KY-28 POWER-MODE C'), category = _('Radio')},
{down = device_commands.RADIO_KY28_POWER_MODE_TOGGLE, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('KY-28 POWER-MODE Toggle'), category = _('Radio')},
{down = device_commands.RADIO_KY28_RADIO_SELECTOR, cockpit_device_id = devices.ICS, value_down = 0, name = _('KY-28 RAD-1'), category = _('Radio')},
{down = device_commands.RADIO_KY28_RADIO_SELECTOR, cockpit_device_id = devices.ICS, value_down = 0.5, name = _('KY-28 RAD-2'), category = _('Radio')},
{down = device_commands.RADIO_KY28_RADIO_SELECTOR_TOGGLE, cockpit_device_id = devices.ICS, value_down = 1, value_up = 0, name = _('KY-28 RAD Toggle'), category = _('Radio')},
{down = device_commands.RADIO_KY28_ZEROIZE_COVER, cockpit_device_id = devices.ICS, value_down=1.0, name = _('KY-28 ZEROIZE Cover Up'), category = _('Radio')},
{down = device_commands.RADIO_KY28_ZEROIZE_COVER, cockpit_device_id = devices.ICS, value_down=0.0, name = _('KY-28 ZEROIZE Cover Down'), category = _('Radio')},
{down = device_commands.RADIO_KY28_ZEROIZE_COVER_TOGGLE, cockpit_device_id = devices.ICS, value_down=1.0, value_up=0.0, name = _('KY-28 ZEROIZE Cover Toggle'), category = _('Radio')},
{down = device_commands.RADIO_KY28_ZEROIZE, up = device_commands.RADIO_KY28_ZEROIZE, cockpit_device_id = devices.ICS, value_down=1.0, value_up=0.0, name = _('KY-28 ZEROIZE'), category = _('Radio')},

-- TACAN
{down = device_commands.TACAN_Knob_Func_RIO, cockpit_device_id = devices.TACAN, value_down = 0.0/4.0, name = _('TACAN Function OFF'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_RIO, cockpit_device_id = devices.TACAN, value_down = 1.0/4.0, name = _('TACAN Function REC'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_RIO, cockpit_device_id = devices.TACAN, value_down = 2.0/4.0, name = _('TACAN Function T/R'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_RIO, cockpit_device_id = devices.TACAN, value_down = 3.0/4.0, name = _('TACAN Function A/A'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_RIO, cockpit_device_id = devices.TACAN, value_down = 4.0/4.0, name = _('TACAN Function BCN'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_STEP_RIO, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN Function Inc'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Func_STEP_RIO, cockpit_device_id = devices.TACAN, value_down = -1, value_up = 0, name = _('TACAN Function Dec'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Tens_Step_RIO, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN Channel 10 Inc'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Tens_Step_RIO, cockpit_device_id = devices.TACAN, value_down = -1, value_up = 0, name = _('TACAN Channel 10 Dec'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Ones_Step_RIO, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN Channel 1 Inc'), category = _('TACAN')},
{down = device_commands.TACAN_Knob_Chnl_Ones_Step_RIO, cockpit_device_id = devices.TACAN, value_down = -1, value_up = 0, name = _('TACAN Channel 1 Dec'), category = _('TACAN')},
{down = device_commands.TACAN_Mode_X_Y_RIO, cockpit_device_id = devices.TACAN, value_down = 0, name = _('TACAN MODE X'), category = _('TACAN')},
{down = device_commands.TACAN_Mode_X_Y_RIO, cockpit_device_id = devices.TACAN, value_down = 1, name = _('TACAN MODE Y'), category = _('TACAN')},
{down = device_commands.TACAN_Mode_X_Y_TOGGLE_RIO, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN MODE X/Y Toggle'), category = _('TACAN')},
{down = device_commands.TACAN_Btn_BIT_RIO, up = device_commands.TACAN_Btn_BIT_RIO, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN BIT Button'), category = _('TACAN')},
{down = device_commands.TACAN_CMD_Btn_RIO, up = device_commands.TACAN_Btn_BIT_RIO, cockpit_device_id = devices.TACAN, value_down = 1, value_up = 0, name = _('TACAN CMD Button'), category = _('TACAN')},
{pressed = device_commands.TACAN_Knob_Vol_STEP_RIO, cockpit_device_id = devices.TACAN, value_pressed = 1.0, value_up = 0, name = _('TACAN Volume Inc'), category = _('TACAN')},
{pressed = device_commands.TACAN_Knob_Vol_STEP_RIO, cockpit_device_id = devices.TACAN, value_pressed = -1.0, value_up = 0, name = _('TACAN Volume Dec'), category = _('TACAN')},

--Weapon binds
{down = device_commands.WEAP_ATTK_Mode, cockpit_device_id=devices.WEAPONS, value_down = 0.00, name = _('ATTK Mode: Computer TGT'), category = _('Weapons')},
{down = device_commands.WEAP_ATTK_Mode, cockpit_device_id=devices.WEAPONS, value_down = 0.25, name = _('ATTK Mode: Computer IP'), category = _('Weapons')},
{down = device_commands.WEAP_ATTK_Mode, cockpit_device_id=devices.WEAPONS, value_down = 0.5, name = _('ATTK Mode: Computer PLT'), category = _('Weapons')},
{down = device_commands.WEAP_ATTK_Mode, cockpit_device_id=devices.WEAPONS, value_down = 0.75, name = _('ATTK Mode: MAN'), category = _('Weapons')},
{down = device_commands.WEAP_ATTK_Mode, cockpit_device_id=devices.WEAPONS, value_down = 1.00, name = _('ATTK Mode: D/L BOMB'), category = _('Weapons')},
{down = device_commands.WEAP_ATTK_Mode_step, cockpit_device_id=devices.WEAPONS, value_down = 1.0, name=_('ATTK mode CW'), category=_('Weapons')},
{down = device_commands.WEAP_ATTK_Mode_step, cockpit_device_id=devices.WEAPONS, value_down = -1.0, name=_('ATTK mode CCW'), category=_('Weapons')},


{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Missile_Option, value_down = 1, up = device_commands.WEAP_Missile_Option, value_up = 0, name = _('Missile Option: Sparrow Pulse Doppler else normal'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Missile_Option, value_down = -1, up = device_commands.WEAP_Missile_Option, value_up = 0, name = _('Missile Option: Phoenix Active else normal'), category = _('Weapons')},
{down = device_commands.WEAP_Missile_Option, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Missile Option: Phoenix Active'), category = _('Weapons')},
{down = device_commands.WEAP_Missile_Option, cockpit_device_id=devices.WEAPONS, value_down = 0, name = _('Missile Option: normal'), category = _('Weapons')},
{down = device_commands.WEAP_Missile_Option, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Missile Option: Sparrow Pulse Doppler'), category = _('Weapons')},

{down = device_commands.WEAP_MSL_SPD_Gate, cockpit_device_id=devices.WEAPONS, value_down = 0.0, name = _('Missile Speed Gate: Wide'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate, cockpit_device_id=devices.WEAPONS, value_down = 0.2, name = _('Missile Speed Gate: Narrow'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate, cockpit_device_id=devices.WEAPONS, value_down = 0.4, name = _('Missile Speed Gate: Nose'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate, cockpit_device_id=devices.WEAPONS, value_down = 0.6, name = _('Missile Speed Gate: Nose Quater'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate, cockpit_device_id=devices.WEAPONS, value_down = 0.8, name = _('Missile Speed Gate: Tail Quater'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate, cockpit_device_id=devices.WEAPONS, value_down = 1.0, name = _('Missile Speed Gate: Tail'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate_step, cockpit_device_id=devices.WEAPONS, value_down = 1.0, name = _('Missile Speed Gate CW'), category = _('Weapons')},
{down = device_commands.WEAP_MSL_SPD_Gate_step, cockpit_device_id=devices.WEAPONS, value_down = -1.0, name = _('Missile Speed Gate CCW'), category = _('Weapons')},

{cockpit_device_id=devices.TID, down = device_commands.WEAP_Next_launch, value_down = 1, up = device_commands.WEAP_Next_launch, value_up = 0, name = _('Next launch'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_AA_Launch, value_down = 1, up = device_commands.WEAP_AA_Launch, value_up = 0, name = _('A2A launch'), category = _('Weapons')},

{down = device_commands.WEAP_Elec_Fuse_step, cockpit_device_id=devices.WEAPONS, value_down = 1.0, name=_('Elec Fuse CW'), category=_('Weapons')},
{down = device_commands.WEAP_Elec_Fuse_step, cockpit_device_id=devices.WEAPONS, value_down = -1.0, name=_('Elec Fuse CCW'), category=_('Weapons')},
{down = device_commands.WEAP_Elec_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 0.0, name=_('Elec Fuse: Safe'), category=_('Weapons')},
{down = device_commands.WEAP_Elec_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 0.25, name=_('Elec Fuse: VT'), category=_('Weapons')},
{down = device_commands.WEAP_Elec_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 0.5, name=_('Elec Fuse: INST'), category=_('Weapons')},
{down = device_commands.WEAP_Elec_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 0.75, name=_('Elec Fuse: DLY1'), category=_('Weapons')},
{down = device_commands.WEAP_Elec_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 1.0, name=_('Elec Fuse: DLY2'), category=_('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Mech_Fuse, value_down = 1, up = device_commands.WEAP_Mech_Fuse, value_up = 0, name = _('Mech Fuze Nose, else Safe'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Mech_Fuse, value_down = -1, up = device_commands.WEAP_Mech_Fuse, value_up = 0, name = _('Mech Fuze Nose/Tail, else Safe'), category = _('Weapons')},
{down = device_commands.WEAP_Mech_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Mech Fuze Nose'), category = _('Weapons')},
{down = device_commands.WEAP_Mech_Fuse, cockpit_device_id=devices.WEAPONS, value_down = 0, name = _('Mech Fuze Safe'), category = _('Weapons')},
{down = device_commands.WEAP_Mech_Fuse, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Mech Fuze Nose/Tail'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Bomb_SinglePairs, value_down = -1, up = device_commands.WEAP_Bomb_SinglePairs, value_up = 1, name = _('Delivery Mode: Pairs, else Single'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Bomb_SinglePairs, value_down = 1, up = device_commands.WEAP_Bomb_SinglePairs, value_up = -1, name = _('Delivery Mode: Single, else Pairs'), category = _('Weapons')},
{down = device_commands.WEAP_Bomb_SinglePairs, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Delivery Mode: Pairs'), category = _('Weapons')},
{down = device_commands.WEAP_Bomb_SinglePairs, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Delivery Mode: Single'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Bomb_StepRipple, value_down = -1, up = device_commands.WEAP_Bomb_StepRipple, value_up = 1, name = _('Delivery Mode: Ripple, else Step'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Bomb_StepRipple, value_down = 1, up = device_commands.WEAP_Bomb_StepRipple, value_up = -1, name = _('Delivery Mode: Step, else Ripple'), category = _('Weapons')},
{down = device_commands.WEAP_Bomb_StepRipple, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Delivery Mode: Ripple'), category = _('Weapons')},
{down = device_commands.WEAP_Bomb_StepRipple, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Delivery Mode: Step'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_AG_Gun, value_down = -1, up = device_commands.WEAP_AG_Gun, value_up = 1, name = _('AG Gun: Off, else Mixed'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_AG_Gun, value_down = 1, up = device_commands.WEAP_AG_Gun, value_up = -1, name = _('AG Gun: Mixed, else Off'), category = _('Weapons')},
{down = device_commands.WEAP_AG_Gun, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('AG gun: Mixed'), category = _('Weapons')},
{down = device_commands.WEAP_AG_Gun, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('AG gun: Off'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Selective_Jett, value_down = -1, up = device_commands.WEAP_Selective_Jett, value_up = 0, name = _('Selective jettison: AUX'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Selective_Jett, value_down = 1, up = device_commands.WEAP_Selective_Jett, value_up = 0, name = _('Selective jettison: JETT'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Jett_RackWeapons, value_down = -1, up = device_commands.WEAP_Jett_RackWeapons, value_up = 1, name = _('Jettison Options: Weapons, else MER/TER'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Jett_RackWeapons, value_down = 1, up = device_commands.WEAP_Jett_RackWeapons, value_up = -1, name = _('Jettison Options: MER/TER, else Weapons'), category = _('Weapons')},
{down = device_commands.WEAP_Jett_RackWeapons, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Jettison Options: Weapons'), category = _('Weapons')},
{down = device_commands.WEAP_Jett_RackWeapons, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Jettison Options: MER/TER'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Jett_LeftTank, value_down = -1, up = device_commands.WEAP_Jett_LeftTank, value_up = 1, name = _('Jettison Left Tank: Safe, else Select'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Jett_LeftTank, value_down = 1, up = device_commands.WEAP_Jett_LeftTank, value_up = -1, name = _('Jettison Left Tank: Select, else Safe'), category = _('Weapons')},
{down = device_commands.WEAP_Jett_LeftTank, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Jettison Left Tank: Safe'), category = _('Weapons')},
{down = device_commands.WEAP_Jett_LeftTank, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Jettison Left Tank: Select'), category = _('Weapons')},

{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Jett_RightTank, value_down = -1, up = device_commands.WEAP_Jett_RightTank, value_up = 1, name = _('Jettison Right Tank: Safe, else Select'), category = _('Weapons')},
{cockpit_device_id=devices.WEAPONS, down = device_commands.WEAP_Jett_RightTank, value_down = 1, up = device_commands.WEAP_Jett_RightTank, value_up = -1, name = _('Jettison Right Tank: Select, else Safe'), category = _('Weapons')},
{down = device_commands.WEAP_Jett_RightTank, cockpit_device_id=devices.WEAPONS, value_down = -1, name = _('Jettison Right Tank: Safe'), category = _('Weapons')},
{down = device_commands.WEAP_Jett_RightTank, cockpit_device_id=devices.WEAPONS, value_down = 1, name = _('Jettison Right Tank: Select'), category = _('Weapons')},


--DECM
{down = device_commands.DECM_Mode_Knob, cockpit_device_id=devices.DECM, value_down = 0.0, name = _('DECM Mode: OFF'), category = _('DECM')},
{down = device_commands.DECM_Mode_Knob, cockpit_device_id=devices.DECM, value_down = 0.2, name = _('DECM Mode: Test STBY'), category = _('DECM')},
{down = device_commands.DECM_Mode_Knob, cockpit_device_id=devices.DECM, value_down = 0.4, name = _('DECM Mode: Test Hold 3sec'), category = _('DECM')},
{down = device_commands.DECM_Mode_Knob, cockpit_device_id=devices.DECM, value_down = 0.6, name = _('DECM Mode: Test ACT'), category = _('DECM')},
{down = device_commands.DECM_Mode_Knob, cockpit_device_id=devices.DECM, value_down = 0.8, name = _('DECM Mode: REC'), category = _('DECM')},
{down = device_commands.DECM_Mode_Knob, cockpit_device_id=devices.DECM, value_down = 1.0, name = _('DECM Mode: RPT'), category = _('DECM')},

-- WARNINGLIGHTS
{	down=device_commands.WLP_Master_Caution_RIO, 	cockpit_device_id=devices.WARNINGLIGHTS, value_down=1.0, name = _('Master Caution Reset'), category = _('Other')},


--**************************************--
---Cockpit mechanics
{combos = {{key='E',reformers={'LShift'}}}, down = device_commands.EJECT_ArmRIOToggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down = -1, name = _('Toggle Arm Ejection Seat'), category = _('Cockpit Mechanics')},

--***************************************** Lights *************************************************************
{ down=device_commands.LIGHTS_WhiteFlood_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights White Flood OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights White Flood BRT'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1.0, name=_('Lights White Flood DIM'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_WhiteFlood_RIO_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights White Flood Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=0.0, name=_('Lights Red Flood OFF'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, name=_('Lights Red Flood BRT'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1.0, name=_('Lights Red Flood DIM'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_RedFlood_RIO_Toggle, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1.0, value_up=0.0, name=_('Lights Red Flood Toggle'),	 category=_('Lights')},
{ down=device_commands.LIGHTS_Instruments_Step_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1, value_up=0, name = _('Lights Instrument Brightness Up'), category = _('Lights')},
{ down=device_commands.LIGHTS_Instruments_Step_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1, value_up=0, name = _('Lights Instrument Brightness Down'), category = _('Lights')},
{ down=device_commands.LIGHTS_Console_Step_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=1, value_up=0, name = _('Lights Console Brightness Up'), category = _('Lights')},
{ down=device_commands.LIGHTS_Console_Step_RIO, cockpit_device_id=devices.COCKPITMECHANICS, value_down=-1, value_up=0, name = _('Lights Console Brightnes Down'), category = _('Lights')},

--
{down = device_commands.TID_VideoExportToggle, cockpit_device_id = devices.TID, value_down = 1, name = _('Video Export Toggle'), category = _('Other')},

})

return res
